/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.PairTable;

public class CpcUnion {
    private final long seed;
    private int lgK;
    private long[] bitMatrix;
    private CpcSketch accumulator;

    public CpcUnion() {
        this(11, 9001L);
    }

    public CpcUnion(int lgK) {
        this(lgK, 9001L);
    }

    public CpcUnion(int lgK, long seed) {
        this.seed = seed;
        this.lgK = lgK;
        this.bitMatrix = null;
        this.accumulator = new CpcSketch(lgK);
    }

    public void update(CpcSketch sketch) {
        CpcUnion.mergeInto(this, sketch);
    }

    public CpcSketch getResult() {
        return CpcUnion.getResult(this);
    }

    public int getLgK() {
        return this.lgK;
    }

    public static Family getFamily() {
        return Family.CPC;
    }

    long getNumCoupons() {
        if (this.bitMatrix != null) {
            return CpcUtil.countBitsSetInMatrix(this.bitMatrix);
        }
        return this.accumulator.numCoupons;
    }

    static long[] getBitMatrix(CpcUnion union) {
        CpcUnion.checkUnionState(union);
        return union.bitMatrix != null ? union.bitMatrix : CpcUtil.bitMatrixOfSketch(union.accumulator);
    }

    private static void walkTableUpdatingSketch(CpcSketch dest, PairTable table) {
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        assert (dest.lgK <= 26);
        int destMask = (1 << dest.lgK) - 1 << 6 | 0x3F;
        int stride = (int)(0.6180339887498949 * (double)numSlots);
        assert (stride >= 2);
        if (stride == stride >>> 1 << 1) {
            ++stride;
        }
        assert (stride >= 3 && stride < numSlots);
        int i = 0;
        int j = 0;
        while (i < numSlots) {
            int rowCol = slots[j &= numSlots - 1];
            if (rowCol != -1) {
                dest.rowColUpdate(rowCol & destMask);
            }
            ++i;
            j += stride;
        }
    }

    private static void orTableIntoMatrix(long[] bitMatrix, int destLgK, PairTable table) {
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        int destMask = (1 << destLgK) - 1;
        for (int i = 0; i < numSlots; ++i) {
            int rowCol = slots[i];
            if (rowCol == -1) continue;
            int col = rowCol & 0x3F;
            int row = rowCol >>> 6;
            int n = row & destMask;
            bitMatrix[n] = bitMatrix[n] | 1L << col;
        }
    }

    private static void orWindowIntoMatrix(long[] destMatrix, int destLgK, byte[] srcWindow, int srcOffset, int srcLgK) {
        assert (destLgK <= srcLgK);
        int destMask = (1 << destLgK) - 1;
        int srcK = 1 << srcLgK;
        for (int srcRow = 0; srcRow < srcK; ++srcRow) {
            int n = srcRow & destMask;
            destMatrix[n] = destMatrix[n] | ((long)srcWindow[srcRow] & 0xFFL) << srcOffset;
        }
    }

    private static void orMatrixIntoMatrix(long[] destMatrix, int destLgK, long[] srcMatrix, int srcLgK) {
        assert (destLgK <= srcLgK);
        int destMask = (1 << destLgK) - 1;
        int srcK = 1 << srcLgK;
        for (int srcRow = 0; srcRow < srcK; ++srcRow) {
            int n = srcRow & destMask;
            destMatrix[n] = destMatrix[n] | srcMatrix[srcRow];
        }
    }

    private static void reduceUnionK(CpcUnion union, int newLgK) {
        assert (newLgK < union.lgK);
        if (union.bitMatrix != null) {
            int newK = 1 << newLgK;
            long[] newMatrix = new long[newK];
            CpcUnion.orMatrixIntoMatrix(newMatrix, newLgK, union.bitMatrix, union.lgK);
            union.bitMatrix = newMatrix;
            union.lgK = newLgK;
        } else {
            CpcSketch oldSketch = union.accumulator;
            if (oldSketch.numCoupons == 0L) {
                union.accumulator = new CpcSketch(newLgK, oldSketch.seed);
                union.lgK = newLgK;
                return;
            }
            CpcSketch newSketch = new CpcSketch(newLgK, oldSketch.seed);
            CpcUnion.walkTableUpdatingSketch(newSketch, oldSketch.pairTable);
            Flavor finalNewFlavor = newSketch.getFlavor();
            assert (finalNewFlavor != Flavor.EMPTY);
            if (finalNewFlavor == Flavor.SPARSE) {
                union.accumulator = newSketch;
                union.lgK = newLgK;
                return;
            }
            union.accumulator = null;
            union.bitMatrix = CpcUtil.bitMatrixOfSketch(newSketch);
            union.lgK = newLgK;
        }
    }

    private static void mergeInto(CpcUnion union, CpcSketch source) {
        if (source == null) {
            return;
        }
        CpcUnion.checkSeeds(union.seed, source.seed);
        int sourceFlavorOrd = source.getFlavor().ordinal();
        if (sourceFlavorOrd == 0) {
            return;
        }
        CpcUnion.checkUnionState(union);
        if (source.lgK < union.lgK) {
            CpcUnion.reduceUnionK(union, source.lgK);
        }
        if (sourceFlavorOrd > 1 && union.accumulator != null) {
            union.bitMatrix = CpcUtil.bitMatrixOfSketch(union.accumulator);
            union.accumulator = null;
        }
        int state = sourceFlavorOrd - 1 << 1 | (union.bitMatrix != null ? 1 : 0);
        switch (state) {
            case 0: {
                if (union.accumulator == null) {
                    throw new SketchesStateException("union.accumulator can never be null here.");
                }
                if (union.accumulator.getFlavor() == Flavor.EMPTY && union.lgK == source.lgK) {
                    union.accumulator = source.copy();
                    break;
                }
                CpcUnion.walkTableUpdatingSketch(union.accumulator, source.pairTable);
                if (union.accumulator.getFlavor().ordinal() <= 1) break;
                union.bitMatrix = CpcUtil.bitMatrixOfSketch(union.accumulator);
                union.accumulator = null;
                break;
            }
            case 1: {
                CpcUnion.orTableIntoMatrix(union.bitMatrix, union.lgK, source.pairTable);
                break;
            }
            case 3: 
            case 5: {
                CpcUnion.orWindowIntoMatrix(union.bitMatrix, union.lgK, source.slidingWindow, source.windowOffset, source.lgK);
                CpcUnion.orTableIntoMatrix(union.bitMatrix, union.lgK, source.pairTable);
                break;
            }
            case 7: {
                long[] sourceMatrix = CpcUtil.bitMatrixOfSketch(source);
                CpcUnion.orMatrixIntoMatrix(union.bitMatrix, union.lgK, sourceMatrix, source.lgK);
                break;
            }
            default: {
                throw new SketchesStateException("Illegal Union state: " + state);
            }
        }
    }

    private static CpcSketch getResult(CpcUnion union) {
        PairTable table;
        int offset;
        long numCoupons;
        CpcUnion.checkUnionState(union);
        if (union.accumulator != null) {
            if (union.accumulator.numCoupons == 0L) {
                CpcSketch result = new CpcSketch(union.lgK, union.accumulator.seed);
                result.mergeFlag = true;
                return result;
            }
            assert (Flavor.SPARSE == union.accumulator.getFlavor());
            CpcSketch result = union.accumulator.copy();
            result.mergeFlag = true;
            return result;
        }
        long[] matrix = union.bitMatrix;
        int lgK = union.lgK;
        CpcSketch result = new CpcSketch(union.lgK, union.seed);
        result.numCoupons = numCoupons = CpcUtil.countBitsSetInMatrix(matrix);
        Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
        assert (flavor.ordinal() > Flavor.SPARSE.ordinal());
        result.windowOffset = offset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
        int k = 1 << lgK;
        byte[] window = new byte[k];
        result.slidingWindow = window;
        int newTableLgSize = Math.max(lgK - 4, 2);
        result.pairTable = table = new PairTable(newTableLgSize, 6 + lgK);
        long maskForClearingWindow = 255L << offset ^ 0xFFFFFFFFFFFFFFFFL;
        long maskForFlippingEarlyZone = (1L << offset) - 1L;
        long allSurprisesORed = 0L;
        for (int i = 0; i < k; ++i) {
            long pattern = matrix[i];
            window[i] = (byte)(pattern >>> offset & 0xFFL);
            pattern &= maskForClearingWindow;
            allSurprisesORed |= (pattern ^= maskForFlippingEarlyZone);
            while (pattern != 0L) {
                int col = Long.numberOfTrailingZeros(pattern);
                pattern ^= 1L << col;
                int rowCol = i << 6 | col;
                boolean isNovel = PairTable.maybeInsert(table, rowCol);
                assert (isNovel);
            }
        }
        result.fiCol = Long.numberOfTrailingZeros(allSurprisesORed);
        if (result.fiCol > offset) {
            result.fiCol = offset;
        }
        result.mergeFlag = true;
        return result;
    }

    private static void checkSeeds(long seedA, long seedB) {
        if (seedA != seedB) {
            throw new SketchesArgumentException("Hash Seeds do not match.");
        }
    }

    private static void checkUnionState(CpcUnion union) {
        if (union == null) {
            throw new SketchesStateException("union cannot be null");
        }
        CpcSketch accumulator = union.accumulator;
        if (!(accumulator != null ^ union.bitMatrix != null)) {
            throw new SketchesStateException("accumulator and bitMatrix cannot be both valid or both null: accumValid = " + (accumulator != null) + ", bitMatrixValid = " + (union.bitMatrix != null));
        }
        if (accumulator != null) {
            if (accumulator.numCoupons > 0L && (accumulator.slidingWindow != null || accumulator.pairTable == null)) {
                throw new SketchesStateException("Non-empty union accumulator must be SPARSE: " + String.valueOf((Object)accumulator.getFlavor()));
            }
            if (union.lgK != accumulator.lgK) {
                throw new SketchesStateException("union LgK must equal accumulator LgK");
            }
        }
    }
}

