/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

@VisibleForTesting
public abstract class ReplicaMultimap<K, C extends ReplicaCollection<?>> {
    final Map<K, C> map;

    ReplicaMultimap(Map<K, C> map) {
        this.map = map;
    }

    public abstract C get(K var1);

    public Iterable<Replica> flattenValues() {
        return Iterables.concat(this.map.values());
    }

    public Iterable<Map.Entry<K, Replica>> flattenEntries() {
        return () -> {
            Stream s = this.map.entrySet().stream().flatMap(entry -> ((ReplicaCollection)entry.getValue()).stream().map(replica -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), (Replica)replica)));
            return s.iterator();
        };
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }

    public Map<K, C> asMap() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaMultimap that = (ReplicaMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static abstract class Builder<K, B extends ReplicaCollection.Builder<?>> {
        final Map<K, B> map = new HashMap<K, B>();

        protected abstract B newBuilder(K var1);

        Builder() {
        }

        public B get(K key) {
            Preconditions.checkNotNull(key);
            return (B)this.map.computeIfAbsent(key, k -> this.newBuilder(key));
        }

        public B getIfPresent(K key) {
            Preconditions.checkNotNull(key);
            return (B)((ReplicaCollection.Builder)this.map.get(key));
        }

        public void put(K key, Replica replica) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull((Object)replica);
            this.get(key).add(replica);
        }
    }
}

