/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.BlockingQueue;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.streaming.StreamingDataInputPlus;
import org.apache.cassandra.utils.concurrent.BlockingQueues;

public class AsyncStreamingInputPlus
extends RebufferingInputStream
implements StreamingDataInputPlus {
    private final Channel channel;
    private ByteBuf currentBuf = Unpooled.EMPTY_BUFFER;
    private final BlockingQueue<ByteBuf> queue = BlockingQueues.newBlockingQueue();
    private boolean isProducerClosed = false;
    private boolean isConsumerClosed = false;

    public AsyncStreamingInputPlus(Channel channel) {
        super(Unpooled.EMPTY_BUFFER.nioBuffer());
        this.channel = channel;
        channel.config().setAutoRead(false);
    }

    public boolean append(ByteBuf buf) throws IllegalStateException {
        if (this.isProducerClosed) {
            return false;
        }
        this.queue.add(buf);
        return true;
    }

    @Override
    protected void reBuffer() throws ClosedChannelException {
        if (this.isConsumerClosed) {
            throw new ClosedChannelException();
        }
        if (this.queue.isEmpty()) {
            this.channel.read();
        }
        this.currentBuf.release();
        this.currentBuf = null;
        this.buffer = null;
        ByteBuf next = null;
        do {
            try {
                next = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (next == null);
        if (next == Unpooled.EMPTY_BUFFER) {
            this.isConsumerClosed = true;
            throw new ClosedChannelException();
        }
        this.currentBuf = next;
        this.buffer = next.nioBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Consumer consumer, long length) throws IOException {
        while (length > 0L) {
            if (!this.buffer.hasRemaining()) {
                this.reBuffer();
            }
            int position = this.buffer.position();
            int limit = this.buffer.limit();
            this.buffer.limit(position + (int)Math.min(length, (long)(limit - position)));
            try {
                int copied = consumer.accept(this.buffer);
                this.buffer.position(position + copied);
                length -= (long)copied;
            }
            finally {
                this.buffer.limit(limit);
            }
        }
    }

    @VisibleForTesting
    public int unsafeAvailable() {
        long count = this.buffer != null ? (long)this.buffer.remaining() : 0L;
        for (ByteBuf buf : this.queue) {
            count += (long)buf.readableBytes();
        }
        return Ints.checkedCast((long)count);
    }

    public boolean isEmpty() {
        return this.isConsumerClosed || this.queue.isEmpty() && (this.buffer == null || !this.buffer.hasRemaining());
    }

    @Override
    public void close() {
        if (this.isConsumerClosed) {
            return;
        }
        this.isConsumerClosed = true;
        if (this.currentBuf != null) {
            this.currentBuf.release();
            this.currentBuf = null;
            this.buffer = null;
        }
        while (true) {
            try {
                ByteBuf buf;
                while ((buf = this.queue.take()) != Unpooled.EMPTY_BUFFER) {
                    buf.release();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void requestClosure() {
        if (!this.isProducerClosed) {
            this.queue.add(Unpooled.EMPTY_BUFFER);
            this.isProducerClosed = true;
        }
    }

    public ByteBufAllocator getAllocator() {
        return this.channel.alloc();
    }

    public static interface Consumer {
        public int accept(ByteBuffer var1) throws IOException;
    }
}

