/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class HashingFlinkCombineRunner<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends AbstractFlinkCombineRunner<K, InputT, AccumT, OutputT, W> {
    @Override
    public void combine(@UnknownKeyFor @NonNull @Initialized AbstractFlinkCombineRunner.FlinkCombiner<K, InputT, AccumT, OutputT> flinkCombiner, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> elements, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TimestampCombiner timestampCombiner = windowingStrategy.getTimestampCombiner();
        ArrayList<WindowedValue<KV<K, InputT>>> inputs = new ArrayList<WindowedValue<KV<K, InputT>>>();
        Iterables.addAll(inputs, elements);
        Set<W> windows = this.collectWindows(inputs);
        Map<W, W> windowToMergeResult = this.mergeWindows(windowingStrategy, windows);
        HashMap<BoundedWindow, Tuple2> mapState = new HashMap<BoundedWindow, Tuple2>();
        Iterator iterator = inputs.iterator();
        WindowedValue currentValue = (WindowedValue)iterator.next();
        Object key = ((KV)currentValue.getValue()).getKey();
        while (true) {
            for (BoundedWindow boundedWindow : currentValue.getWindows()) {
                BoundedWindow currentWindow = boundedWindow;
                BoundedWindow mergedWindow = (BoundedWindow)windowToMergeResult.get(currentWindow);
                mergedWindow = mergedWindow == null ? currentWindow : mergedWindow;
                Set<BoundedWindow> singletonW = Collections.singleton(mergedWindow);
                Tuple2 accumAndInstant = (Tuple2)mapState.get(mergedWindow);
                if (accumAndInstant == null) {
                    Object accumT = flinkCombiner.firstInput(key, ((KV)currentValue.getValue()).getValue(), options, sideInputReader, singletonW);
                    Instant windowTimestamp = timestampCombiner.assign(mergedWindow, currentValue.getTimestamp());
                    accumAndInstant = new Tuple2(accumT, (Object)windowTimestamp);
                    mapState.put(mergedWindow, accumAndInstant);
                    continue;
                }
                accumAndInstant.f0 = flinkCombiner.addInput(key, accumAndInstant.f0, ((KV)currentValue.getValue()).getValue(), options, sideInputReader, singletonW);
                accumAndInstant.f1 = timestampCombiner.combine(new Instant[]{(Instant)accumAndInstant.f1, timestampCombiner.assign(mergedWindow, currentValue.getTimestamp())});
            }
            if (!iterator.hasNext()) break;
            currentValue = (WindowedValue)iterator.next();
        }
        for (Map.Entry entry : mapState.entrySet()) {
            Object accumulator = ((Tuple2)entry.getValue()).f0;
            Instant windowTimestamp = (Instant)((Tuple2)entry.getValue()).f1;
            out.collect((Object)WindowedValues.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, Collections.singleton((BoundedWindow)entry.getKey()))), (Instant)windowTimestamp, (BoundedWindow)((BoundedWindow)entry.getKey()), (PaneInfo)PaneInfo.NO_FIRING));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Map<W, W> mergeWindows(@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Set<W> windows) throws @UnknownKeyFor @NonNull @Initialized Exception {
        WindowFn windowFn = windowingStrategy.getWindowFn();
        if (!windowingStrategy.needsMerge()) {
            return Collections.emptyMap();
        }
        HashMap windowToMergeResult = new HashMap();
        windowFn.mergeWindows((WindowFn.MergeContext)new MergeContextImpl(windowFn, windows, windowToMergeResult));
        return windowToMergeResult;
    }

    private @UnknownKeyFor @NonNull @Initialized Set<W> collectWindows(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> values) {
        HashSet<BoundedWindow> windows = new HashSet<BoundedWindow>();
        for (WindowedValue<KV<K, InputT>> value : values) {
            Iterator iterator = value.getWindows().iterator();
            while (iterator.hasNext()) {
                BoundedWindow untypedWindow;
                BoundedWindow window = untypedWindow = (BoundedWindow)iterator.next();
                windows.add(window);
            }
        }
        return windows;
    }

    private class MergeContextImpl
    extends WindowFn.MergeContext {
        private @UnknownKeyFor @NonNull @Initialized Set<W> windows;
        private @UnknownKeyFor @NonNull @Initialized Map<W, W> windowToMergeResult;

        MergeContextImpl(@UnknownKeyFor @NonNull @Initialized WindowFn<Object, W> windowFn, @UnknownKeyFor @NonNull @Initialized Set<W> windows, Map<W, W> windowToMergeResult) {
            super(windowFn);
            this.windows = windows;
            this.windowToMergeResult = windowToMergeResult;
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<W> windows() {
            return this.windows;
        }

        public void merge(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (BoundedWindow w : toBeMerged) {
                this.windowToMergeResult.put(w, mergeResult);
            }
        }
    }
}

