/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ExpiringMemoizingSerializableSupplier<@UnknownKeyFor T>
implements SerializableSupplier<T> {
    private static final @UnknownKeyFor @NonNull @Initialized AtomicLongFieldUpdater<@UnknownKeyFor @NonNull @Initialized ExpiringMemoizingSerializableSupplier> DEADLINE_NANOS = AtomicLongFieldUpdater.newUpdater(ExpiringMemoizingSerializableSupplier.class, "deadlineNanos");
    private final @UnknownKeyFor @NonNull @Initialized SerializableSupplier<T> supplier;
    private final @UnknownKeyFor @NonNull @Initialized long periodNanos;
    private transient T value;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long deadlineNanos;

    public ExpiringMemoizingSerializableSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<T> supplier, @UnknownKeyFor @NonNull @Initialized Duration period, T initialValue, @UnknownKeyFor @NonNull @Initialized Duration initialDelay) {
        this.supplier = supplier;
        this.periodNanos = period.toNanos();
        this.value = initialValue;
        this.deadlineNanos = System.nanoTime() + initialDelay.toNanos() & 0xFFFFFFFFFFFFFFFEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T result;
        long nowNanos;
        long deadlineNanos = this.deadlineNanos;
        if ((deadlineNanos & 1L) == 0L && deadlineNanos - (nowNanos = System.nanoTime()) <= 0L && DEADLINE_NANOS.compareAndSet(this, deadlineNanos, deadlineNanos | 1L)) {
            try {
                this.value = result = this.supplier.get();
            }
            finally {
                DEADLINE_NANOS.lazySet(this, nowNanos + this.periodNanos & 0xFFFFFFFFFFFFFFFEL);
            }
        } else {
            result = this.value;
        }
        return result;
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        is.defaultReadObject();
        this.deadlineNanos = System.nanoTime() & 0xFFFFFFFFFFFFFFFEL;
    }
}

