/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.salesforce;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="salesforceconnection", name="i18n::SalesforceConnection.name", description="i18n::SalesforceConnection.description", image="salesforce.svg", documentationUrl="/metadata-types/salesforce-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.REST_CONNECTION)
public class SalesforceConnection
extends HopMetadataBase
implements IHopMetadata {
    @HopMetadataProperty(key="authentication_type", injectionKey="AUTHENTICATION_TYPE")
    private String authenticationType = "USERNAME_PASSWORD";
    @HopMetadataProperty(key="username", injectionKey="USERNAME")
    private String username;
    @HopMetadataProperty(key="password", injectionKey="PASSWORD")
    private String password;
    @HopMetadataProperty(key="security_token", injectionKey="SECURITY_TOKEN")
    private String securityToken;
    @HopMetadataProperty(key="target_url", injectionKey="TARGET_URL")
    private String targetUrl;
    @HopMetadataProperty(key="oauth_client_id", injectionKey="OAUTH_CLIENT_ID")
    private String oauthClientId;
    @HopMetadataProperty(key="oauth_client_secret", injectionKey="OAUTH_CLIENT_SECRET")
    private String oauthClientSecret;
    @HopMetadataProperty(key="oauth_redirect_uri", injectionKey="OAUTH_REDIRECT_URI")
    private String oauthRedirectUri = "http://localhost:8080/callback";
    @HopMetadataProperty(key="oauth_access_token", injectionKey="OAUTH_ACCESS_TOKEN", password=true)
    private String oauthAccessToken;
    @HopMetadataProperty(key="oauth_refresh_token", injectionKey="OAUTH_REFRESH_TOKEN", password=true)
    private String oauthRefreshToken;
    @HopMetadataProperty(key="oauth_instance_url", injectionKey="OAUTH_INSTANCE_URL")
    private String oauthInstanceUrl;
    @HopMetadataProperty(key="oauth_jwt_username", injectionKey="OAUTH_JWT_USERNAME")
    private String oauthJwtUsername;
    @HopMetadataProperty(key="oauth_jwt_consumer_key", injectionKey="OAUTH_JWT_CONSUMER_KEY")
    private String oauthJwtConsumerKey;
    @HopMetadataProperty(key="oauth_jwt_private_key", injectionKey="OAUTH_JWT_PRIVATE_KEY", password=true)
    private String oauthJwtPrivateKey;
    @HopMetadataProperty(key="oauth_jwt_token_endpoint", injectionKey="OAUTH_JWT_TOKEN_ENDPOINT")
    private String oauthJwtTokenEndpoint = "https://login.salesforce.com";

    public SalesforceConnection() {
    }

    public SalesforceConnection(String name) {
        super(name);
    }

    public boolean isOAuthAuthentication() {
        return "OAUTH".equalsIgnoreCase(this.authenticationType);
    }

    public boolean isUsernamePasswordAuthentication() {
        return "USERNAME_PASSWORD".equalsIgnoreCase(this.authenticationType);
    }

    public boolean isOAuthJwtAuthentication() {
        return "OAUTH_JWT".equalsIgnoreCase(this.authenticationType);
    }

    public org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection createConnection(IVariables variables, ILogChannel log) throws HopException {
        if (this.isOAuthAuthentication()) {
            String clientId = variables.resolve(this.oauthClientId);
            String clientSecret = Utils.resolvePassword((IVariables)variables, (String)this.oauthClientSecret);
            String accessToken = Utils.resolvePassword((IVariables)variables, (String)this.oauthAccessToken);
            String refreshToken = Utils.resolvePassword((IVariables)variables, (String)this.oauthRefreshToken);
            String instanceUrl = variables.resolve(this.oauthInstanceUrl);
            org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection connection = new org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection(log, clientId, clientSecret, accessToken, instanceUrl);
            if (!Utils.isEmpty((CharSequence)refreshToken)) {
                connection.setOauthRefreshToken(refreshToken);
            }
            return connection;
        }
        if (this.isOAuthJwtAuthentication()) {
            String jwtUsername = variables.resolve(this.oauthJwtUsername);
            String jwtConsumerKey = variables.resolve(this.oauthJwtConsumerKey);
            String jwtPrivateKey = Utils.resolvePassword((IVariables)variables, (String)this.oauthJwtPrivateKey);
            String jwtTokenEndpoint = variables.resolve(this.oauthJwtTokenEndpoint);
            return org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection.createJwtConnection(log, jwtUsername, jwtConsumerKey, jwtPrivateKey, jwtTokenEndpoint);
        }
        String url = variables.resolve(this.targetUrl);
        String user = variables.resolve(this.username);
        Object pass = Utils.resolvePassword((IVariables)variables, (String)this.password);
        String secToken = variables.resolve(this.securityToken);
        if (!Utils.isEmpty((CharSequence)secToken)) {
            pass = (String)pass + secToken;
        }
        return new org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection(log, url, user, (String)pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(IVariables variables, ILogChannel log) throws HopException {
        org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection sfConnection = null;
        try {
            sfConnection = this.createConnection(variables, log);
            sfConnection.connect();
            if (log.isDetailed()) {
                log.logDetailed("Salesforce connection test successful");
            }
        }
        finally {
            if (sfConnection != null) {
                try {
                    sfConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    public String getOauthRedirectUri() {
        return this.oauthRedirectUri;
    }

    public void setOauthRedirectUri(String oauthRedirectUri) {
        this.oauthRedirectUri = oauthRedirectUri;
    }

    public String getOauthAccessToken() {
        return this.oauthAccessToken;
    }

    public void setOauthAccessToken(String oauthAccessToken) {
        this.oauthAccessToken = oauthAccessToken;
    }

    public String getOauthRefreshToken() {
        return this.oauthRefreshToken;
    }

    public void setOauthRefreshToken(String oauthRefreshToken) {
        this.oauthRefreshToken = oauthRefreshToken;
    }

    public String getOauthInstanceUrl() {
        return this.oauthInstanceUrl;
    }

    public void setOauthInstanceUrl(String oauthInstanceUrl) {
        this.oauthInstanceUrl = oauthInstanceUrl;
    }

    public String getOauthJwtUsername() {
        return this.oauthJwtUsername;
    }

    public void setOauthJwtUsername(String oauthJwtUsername) {
        this.oauthJwtUsername = oauthJwtUsername;
    }

    public String getOauthJwtConsumerKey() {
        return this.oauthJwtConsumerKey;
    }

    public void setOauthJwtConsumerKey(String oauthJwtConsumerKey) {
        this.oauthJwtConsumerKey = oauthJwtConsumerKey;
    }

    public String getOauthJwtPrivateKey() {
        return this.oauthJwtPrivateKey;
    }

    public void setOauthJwtPrivateKey(String oauthJwtPrivateKey) {
        this.oauthJwtPrivateKey = oauthJwtPrivateKey;
    }

    public String getOauthJwtTokenEndpoint() {
        return this.oauthJwtTokenEndpoint;
    }

    public void setOauthJwtTokenEndpoint(String oauthJwtTokenEndpoint) {
        this.oauthJwtTokenEndpoint = oauthJwtTokenEndpoint;
    }

    public boolean isPrivateKeySecure() {
        if (Utils.isEmpty((CharSequence)this.oauthJwtPrivateKey)) {
            return false;
        }
        if (this.oauthJwtPrivateKey.contains("${")) {
            return true;
        }
        if (this.oauthJwtPrivateKey.startsWith("Encrypted ")) {
            return true;
        }
        return this.oauthJwtPrivateKey.contains("BEGIN PRIVATE KEY") && this.oauthJwtPrivateKey.contains("END PRIVATE KEY");
    }
}

