/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.plugin.MetadataPluginType;

public class BaseMetadataProvider {
    protected IVariables variables;
    protected String description;

    public BaseMetadataProvider(IVariables variables, String description) {
        this.variables = variables;
        this.description = description;
    }

    public <T extends IHopMetadata> List<Class<T>> getMetadataClasses() {
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
            for (IPlugin plugin : registry.getPlugins(MetadataPluginType.class)) {
                String className = plugin.getClassMap().get(plugin.getMainType());
                Class<?> pluginClass = registry.getClassLoader(plugin).loadClass(className);
                classes.add(pluginClass);
            }
            return classes;
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing metadata plugin classes (setup issue?)", e);
        }
    }

    public <T extends IHopMetadata> Class<T> getMetadataClassForKey(String key) throws HopException {
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            IPlugin plugin = registry.findPluginWithId(MetadataPluginType.class, key);
            if (plugin == null) {
                throw new HopException("The metadata plugin for key " + key + " could not be found in the plugin registry");
            }
            String className = plugin.getClassMap().get(plugin.getMainType());
            Class<?> pluginClass = registry.getClassLoader(plugin).loadClass(className);
            return pluginClass;
        }
        catch (Exception e) {
            throw new HopException("Error find metadata class for key " + key, e);
        }
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

