/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.binary;

import java.util.Iterator;
import org.psjava.ds.tree.binary.BinaryTreeNodeWithParent;
import org.psjava.ds.tree.binary.bst.MinimumFinder;
import org.psjava.ds.tree.binary.bst.SuccessorFinder;
import org.psjava.util.AssertStatus;
import org.psjava.util.ReadOnlyIterator;

public class InOrderIterator {
    public static <D2, D1 extends D2> Iterator<D2> create(final BinaryTreeNodeWithParent<D1> rootOrNull) {
        return new ReadOnlyIterator<D2>(){
            BinaryTreeNodeWithParent<D1> nextOrNull;
            {
                this.nextOrNull = rootOrNull == null ? null : MinimumFinder.find(rootOrNull);
            }

            @Override
            public boolean hasNext() {
                return this.nextOrNull != null;
            }

            @Override
            public D2 next() {
                AssertStatus.assertTrue(this.nextOrNull != null);
                BinaryTreeNodeWithParent r = this.nextOrNull;
                this.nextOrNull = SuccessorFinder.findOrNull(r);
                return r.getData();
            }
        };
    }

    private InOrderIterator() {
    }
}

