/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.replication.fluent;

import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.ReplicationProtocol;
import com.amazon.redshift.replication.RedshiftReplicationStream;
import com.amazon.redshift.replication.fluent.ChainedStreamBuilder;
import com.amazon.redshift.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.amazon.redshift.replication.fluent.logical.LogicalReplicationOptions;
import com.amazon.redshift.replication.fluent.logical.LogicalStreamBuilder;
import com.amazon.redshift.replication.fluent.logical.StartLogicalReplicationCallback;
import com.amazon.redshift.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.amazon.redshift.replication.fluent.physical.PhysicalReplicationOptions;
import com.amazon.redshift.replication.fluent.physical.PhysicalStreamBuilder;
import com.amazon.redshift.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public RedshiftReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options, ReplicationStreamBuilder.this.baseConnection.getLogger());
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public RedshiftReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options, ReplicationStreamBuilder.this.baseConnection.getLogger());
            }
        });
    }
}

