/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util.format;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.sql.engine.util.format.DateTimeFormatElement;
import org.apache.ignite3.internal.sql.engine.util.format.DateTimeTemplateField;
import org.apache.ignite3.internal.sql.engine.util.format.Formatter;
import org.apache.ignite3.internal.sql.engine.util.format.ParsedFields;
import org.apache.ignite3.internal.sql.engine.util.format.Parser;
import org.apache.ignite3.internal.sql.engine.util.format.Scanner;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

public final class SqlDateTimeFormatter {
    private static final Clock CLOCK = Clock.systemDefaultZone();
    private static final Set<DateTimeTemplateField.FieldKind> DATE_FIELDS = Set.of(DateTimeTemplateField.FieldKind.YEAR, DateTimeTemplateField.FieldKind.ROUNDED_YEAR, DateTimeTemplateField.FieldKind.MONTH, DateTimeTemplateField.FieldKind.DAY_OF_MONTH, DateTimeTemplateField.FieldKind.DAY_OF_YEAR);
    private static final Set<DateTimeTemplateField.FieldKind> TIME_FIELDS = Set.of(DateTimeTemplateField.FieldKind.HOUR_12, DateTimeTemplateField.FieldKind.HOUR_24, DateTimeTemplateField.FieldKind.MINUTE, DateTimeTemplateField.FieldKind.SECOND_OF_MINUTE, DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.FRACTION, DateTimeTemplateField.FieldKind.AM_PM);
    private static final Set<DateTimeTemplateField.FieldKind> TIMESTAMP_FIELDS = Set.of(DateTimeTemplateField.FieldKind.YEAR, DateTimeTemplateField.FieldKind.ROUNDED_YEAR, DateTimeTemplateField.FieldKind.MONTH, DateTimeTemplateField.FieldKind.DAY_OF_MONTH, DateTimeTemplateField.FieldKind.DAY_OF_YEAR, DateTimeTemplateField.FieldKind.HOUR_12, DateTimeTemplateField.FieldKind.HOUR_24, DateTimeTemplateField.FieldKind.MINUTE, DateTimeTemplateField.FieldKind.SECOND_OF_MINUTE, DateTimeTemplateField.FieldKind.SECOND_OF_DAY, DateTimeTemplateField.FieldKind.FRACTION, DateTimeTemplateField.FieldKind.AM_PM, DateTimeTemplateField.FieldKind.TIMEZONE);
    private final List<DateTimeFormatElement> elements;

    SqlDateTimeFormatter(List<DateTimeFormatElement> elements) {
        this.elements = elements;
    }

    public static SqlDateTimeFormatter timeFormatter(String pattern) {
        try {
            return new SqlDateTimeFormatter(new Scanner(pattern, "TIME", TIME_FIELDS).scan());
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }

    public String formatTime(LocalTime value) {
        Formatter formatter = new Formatter(this.elements);
        return formatter.format(value, ZoneOffset.UTC);
    }

    public LocalTime parseTime(String input) {
        Objects.requireNonNull(input, "input");
        Parser parser = new Parser(this.elements);
        try {
            ParsedFields fields = parser.parse(input);
            return fields.getTime();
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }

    public static SqlDateTimeFormatter dateFormatter(String pattern) {
        try {
            return new SqlDateTimeFormatter(new Scanner(pattern, "DATE", DATE_FIELDS).scan());
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }

    public String formatDate(LocalDate value) {
        Formatter formatter = new Formatter(this.elements);
        return formatter.format(value, ZoneOffset.UTC);
    }

    public LocalDate parseDate(String input) {
        return this.parseDate(input, CLOCK);
    }

    public LocalDate parseDate(String input, Clock clock) {
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(clock, "clock");
        Parser parser = new Parser(this.elements);
        try {
            ParsedFields fields = parser.parse(input);
            return fields.getDate(clock);
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }

    public static SqlDateTimeFormatter timestampFormatter(String pattern) {
        try {
            return new SqlDateTimeFormatter(new Scanner(pattern, "TIMESTAMP", TIMESTAMP_FIELDS).scan());
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }

    public String formatTimestamp(LocalDateTime value, ZoneOffset offset) {
        Formatter formatter = new Formatter(this.elements);
        return formatter.format(value, offset);
    }

    public LocalDateTime parseTimestamp(String input) {
        return this.parseTimestamp(input, CLOCK);
    }

    public LocalDateTime parseTimestamp(String input, Clock clock) {
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(clock, "clock");
        Parser parser = new Parser(this.elements);
        try {
            ParsedFields fields = parser.parse(input);
            LocalDate date = fields.getDate(clock);
            LocalTime time = fields.getTime();
            LocalDateTime dateTime = LocalDateTime.of(date, time);
            ZoneOffset zoneOffset = fields.toZoneOffset();
            if (zoneOffset != null) {
                return dateTime.minusSeconds(zoneOffset.getTotalSeconds());
            }
            return dateTime;
        }
        catch (DateTimeException e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, e.getMessage(), (Throwable)e);
        }
    }
}

