/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema.ConvertSchemaPredicateToFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.AlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.NonAlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.DeviceInCacheFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.SchemaPredicateUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceCacheAttributeGuard;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceNormalSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FetchDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.scheduler.AsyncSendPlanNodeHandler;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.table.DataNodeTreeViewSchemaUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;

public class TableDeviceSchemaFetcher {
    private final SqlParser relationSqlParser = new SqlParser();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final TableDeviceSchemaCache cache = TableDeviceSchemaCache.getInstance();
    private final TableDeviceCacheAttributeGuard attributeGuard = new TableDeviceCacheAttributeGuard();

    private TableDeviceSchemaFetcher() {
    }

    public static TableDeviceSchemaFetcher getInstance() {
        return TableDeviceSchemaFetcherHolder.INSTANCE;
    }

    public TableDeviceCacheAttributeGuard getAttributeGuard() {
        return this.attributeGuard;
    }

    Map<IDeviceID, Map<String, Binary>> fetchMissingDeviceSchemaForDataInsertion(FetchDevice statement, MPPQueryContext context) {
        long queryId = SessionManager.getInstance().requestQueryId();
        Throwable t = null;
        String database = statement.getDatabase();
        String table = statement.getTableName();
        TsTable tableInstance = DataNodeTableCache.getInstance().getTable(database, table);
        Set<Long> queryIdSet = this.attributeGuard.addFetchQueryId(queryId);
        try {
            ExecutionResult executionResult = this.coordinator.executeForTableModel(statement, this.relationSqlParser, SessionManager.getInstance().getCurrSession(), queryId, context == null ? SessionManager.getInstance().getSessionInfoOfTableModel(SessionManager.getInstance().getCurrSession()) : context.getSession(), "Fetch Device for insert", LocalExecutionPlanner.getInstance().metadata, Long.MAX_VALUE, false);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException(executionResult.status.getMessage(), executionResult.status.getCode());
            }
            List<ColumnHeader> columnHeaderList = this.coordinator.getQueryExecution(queryId).getDatasetHeader().getColumnHeaders();
            int idLength = DataNodeTableCache.getInstance().getTable(database, table).getTagNum();
            HashMap<IDeviceID, Map<String, Binary>> fetchedDeviceSchema = new HashMap<IDeviceID, Map<String, Binary>>();
            while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                Optional<TsBlock> tsBlock;
                try {
                    tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                }
                catch (IoTDBException e) {
                    t = e;
                    throw AsyncSendPlanNodeHandler.needRetry((Exception)((Object)e)) ? new IoTDBRuntimeException(e.getCause(), TSStatusCode.SYNC_CONNECTION_ERROR.getStatusCode()) : new IoTDBRuntimeException(String.format("Fetch Table Device Schema failed because %s", e.getMessage()), e.getErrorCode(), e.isUserException());
                }
                if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                Column[] columns = tsBlock.get().getValueColumns();
                for (int i = 0; i < tsBlock.get().getPositionCount(); ++i) {
                    String[] nodes = new String[idLength + 1];
                    HashMap<String, Binary> attributeMap = new HashMap<String, Binary>();
                    this.constructNodsArrayAndAttributeMap(attributeMap, nodes, table, columnHeaderList, columns, tableInstance, i);
                    fetchedDeviceSchema.put(IDeviceID.Factory.DEFAULT_FACTORY.create(nodes), attributeMap);
                }
            }
            fetchedDeviceSchema.forEach((key, value) -> this.cache.putAttributes(database, (IDeviceID)key, (Map<String, Binary>)value));
            HashMap<IDeviceID, Map<String, Binary>> hashMap = fetchedDeviceSchema;
            return hashMap;
        }
        catch (Throwable throwable) {
            t = throwable;
            throw throwable;
        }
        finally {
            queryIdSet.remove(queryId);
            this.attributeGuard.tryUpdateCache();
            this.coordinator.cleanupQueryExecution(queryId, null, t);
        }
    }

    public Map<String, List<DeviceEntry>> fetchDeviceSchemaForDataQuery(String database, String table, List<Expression> expressionList, List<String> attributeColumns, MPPQueryContext queryContext) {
        ShowDevice statement;
        HashMap<String, List<DeviceEntry>> deviceEntryMap = new HashMap<String, List<DeviceEntry>>();
        TsTable tableInstance = DataNodeTableCache.getInstance().getTable(database, table);
        AtomicBoolean mayContainDuplicateDevice = new AtomicBoolean(false);
        if (!TreeViewSchema.isTreeViewTable((TsTable)tableInstance)) {
            deviceEntryMap.put(database, new ArrayList());
        }
        if (this.parseFilter4TraverseDevice(tableInstance, expressionList, statement = new ShowDevice(database, table), deviceEntryMap, attributeColumns, queryContext, mayContainDuplicateDevice, false)) {
            this.fetchMissingDeviceSchemaForQuery(database, tableInstance, attributeColumns, statement, deviceEntryMap, queryContext);
        }
        return mayContainDuplicateDevice.get() ? deviceEntryMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList(new LinkedHashSet((Collection)entry.getValue())))) : deviceEntryMap;
    }

    public boolean parseFilter4TraverseDevice(TsTable tableInstance, List<Expression> expressionList, AbstractTraverseDevice statement, Map<String, List<DeviceEntry>> deviceEntryMap, List<String> attributeColumns, MPPQueryContext queryContext, AtomicBoolean mayContainDuplicateDevice, boolean isDirectDeviceQuery) {
        ArrayList<IDeviceID> fetchPaths;
        Pair<List<Expression>, List<Expression>> separatedExpression = SchemaPredicateUtil.separateTagDeterminedPredicate(expressionList, tableInstance, queryContext, isDirectDeviceQuery);
        List tagDeterminedPredicateList = (List)separatedExpression.left;
        List tagFuzzyPredicateList = (List)separatedExpression.right;
        Expression compactedTagFuzzyPredicate = SchemaPredicateUtil.compactDeviceIdFuzzyPredicate(tagFuzzyPredicateList);
        List<Map<Integer, List<SchemaFilter>>> index2FilterMapList = SchemaPredicateUtil.convertDeviceIdPredicateToOrConcatList(tagDeterminedPredicateList, tableInstance, mayContainDuplicateDevice);
        List<Integer> tagSingleMatchIndexList = SchemaPredicateUtil.extractTagSingleMatchExpressionCases(index2FilterMapList, tableInstance);
        ArrayList<Integer> tagSingleMatchPredicateNotInCache = new ArrayList<Integer>();
        boolean isExactDeviceQuery = tagSingleMatchIndexList.size() == index2FilterMapList.size();
        ArrayList<IDeviceID> arrayList = fetchPaths = isExactDeviceQuery ? new ArrayList<IDeviceID>() : null;
        if (!tagSingleMatchIndexList.isEmpty()) {
            SchemaFilter fuzzyFilter;
            ConvertSchemaPredicateToFilterVisitor visitor = new ConvertSchemaPredicateToFilterVisitor();
            ConvertSchemaPredicateToFilterVisitor.Context context = new ConvertSchemaPredicateToFilterVisitor.Context(tableInstance);
            DeviceInCacheFilterVisitor filterVisitor = new DeviceInCacheFilterVisitor(attributeColumns);
            Predicate<AlignedDeviceEntry> check = Objects.isNull(compactedTagFuzzyPredicate) ? o -> true : (Objects.nonNull(fuzzyFilter = compactedTagFuzzyPredicate.accept(visitor, context)) && !TreeViewSchema.isTreeViewTable((TsTable)tableInstance) ? o -> filterVisitor.process(fuzzyFilter, o) : null);
            for (int index : tagSingleMatchIndexList) {
                if (this.tryGetDeviceInCache(deviceEntryMap, statement.getDatabase(), tableInstance, index2FilterMapList.get(index), check, attributeColumns, fetchPaths, isDirectDeviceQuery, queryContext)) continue;
                tagSingleMatchPredicateNotInCache.add(index);
            }
        }
        if (tagSingleMatchIndexList.size() < index2FilterMapList.size() || !tagSingleMatchPredicateNotInCache.isEmpty()) {
            ArrayList<List<SchemaFilter>> tagPredicateForFetch = new ArrayList<List<SchemaFilter>>(index2FilterMapList.size() - tagSingleMatchIndexList.size() + tagSingleMatchPredicateNotInCache.size());
            if (!isDirectDeviceQuery) {
                int idx1 = 0;
                int idx2 = 0;
                for (int i = 0; i < index2FilterMapList.size(); ++i) {
                    if (idx1 >= tagSingleMatchIndexList.size() || i != tagSingleMatchIndexList.get(idx1)) {
                        tagPredicateForFetch.add(index2FilterMapList.get(i).values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                        continue;
                    }
                    ++idx1;
                    if (idx2 >= tagSingleMatchPredicateNotInCache.size() || i != (Integer)tagSingleMatchPredicateNotInCache.get(idx2)) continue;
                    tagPredicateForFetch.add(index2FilterMapList.get(i).values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                    ++idx2;
                }
            } else {
                for (Map<Integer, List<SchemaFilter>> integerListMap : index2FilterMapList) {
                    tagPredicateForFetch.add(integerListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                }
            }
            statement.setTagDeterminedFilterList(tagPredicateForFetch);
            statement.setTagFuzzyPredicate(compactedTagFuzzyPredicate);
            statement.setPartitionKeyList(fetchPaths);
            if (!isDirectDeviceQuery && Objects.isNull(fetchPaths)) {
                statement.setAttributeColumns(attributeColumns);
            }
            return true;
        }
        return false;
    }

    private boolean tryGetDeviceInCache(Map<String, List<DeviceEntry>> deviceEntryMap, String database, TsTable tableInstance, Map<Integer, List<SchemaFilter>> idFilters, Predicate<AlignedDeviceEntry> check, List<String> attributeColumns, List<IDeviceID> fetchPaths, boolean isDirectDeviceQuery, MPPQueryContext queryContext) {
        String[] idValues = new String[tableInstance.getTagNum()];
        for (List<SchemaFilter> schemaFilters : idFilters.values()) {
            TagFilter tagFilter = (TagFilter)schemaFilters.get(0);
            SchemaFilter childFilter = tagFilter.getChild();
            idValues[tagFilter.getIndex()] = ((PreciseFilter)childFilter).getValue();
        }
        return !TreeViewSchema.isTreeViewTable((TsTable)tableInstance) ? this.tryGetTableDeviceInCache(Objects.nonNull(deviceEntryMap) ? deviceEntryMap.get(database) : null, database, tableInstance, check, attributeColumns, fetchPaths, isDirectDeviceQuery, idValues, queryContext) : this.tryGetTreeDeviceInCache(deviceEntryMap, tableInstance, check, fetchPaths, idValues);
    }

    private boolean tryGetTableDeviceInCache(List<DeviceEntry> deviceEntryList, String database, TsTable tableInstance, Predicate<AlignedDeviceEntry> check, List<String> attributeColumns, List<IDeviceID> fetchPaths, boolean isDirectDeviceQuery, String[] tagValues, MPPQueryContext queryContext) {
        IDeviceID deviceID = TableDeviceSchemaFetcher.convertTagValuesToDeviceID(tableInstance.getTableName(), tagValues);
        Map<String, Binary> attributeMap = this.cache.getDeviceAttribute(database, deviceID);
        if (Objects.isNull(attributeMap) || Objects.isNull(deviceEntryList) || Objects.isNull(check)) {
            if (Objects.nonNull(fetchPaths)) {
                fetchPaths.add(deviceID);
            }
            return false;
        }
        AlignedDeviceEntry deviceEntry = new AlignedDeviceEntry(deviceID, (Binary[])attributeColumns.stream().map(attributeMap::get).toArray(Binary[]::new));
        if (check.test(deviceEntry)) {
            deviceEntryList.add(deviceEntry);
            if (isDirectDeviceQuery) {
                fetchPaths.add(deviceID);
            } else {
                queryContext.reserveMemoryForFrontEnd(deviceEntry.ramBytesUsed());
            }
        }
        return true;
    }

    private boolean tryGetTreeDeviceInCache(Map<String, List<DeviceEntry>> deviceEntryMap, TsTable tableInstance, Predicate<AlignedDeviceEntry> check, List<IDeviceID> fetchPaths, String[] tagValues) {
        IDeviceID deviceID = DataNodeTreeViewSchemaUtils.convertToIDeviceID(tableInstance, tagValues);
        IDeviceSchema schema = TableDeviceSchemaCache.getInstance().getDeviceSchema(deviceID);
        if (!(schema instanceof TreeDeviceNormalSchema) || Objects.isNull(check)) {
            if (Objects.nonNull(fetchPaths)) {
                fetchPaths.add(deviceID);
            }
            return false;
        }
        String database = ((TreeDeviceNormalSchema)schema).getDatabase();
        deviceEntryMap.computeIfAbsent(database, k -> new ArrayList()).add(((TreeDeviceNormalSchema)schema).isAligned() ? new AlignedDeviceEntry(deviceID, new Binary[0]) : new NonAlignedDeviceEntry(deviceID, new Binary[0]));
        return true;
    }

    public static IDeviceID convertTagValuesToDeviceID(String tableName, String[] idValues) {
        String[] deviceIdNodes = new String[idValues.length + 1];
        deviceIdNodes[0] = tableName;
        System.arraycopy(idValues, 0, deviceIdNodes, 1, idValues.length);
        return IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdNodes);
    }

    private void fetchMissingDeviceSchemaForQuery(String database, TsTable tableInstance, List<String> attributeColumns, ShowDevice statement, Map<String, List<DeviceEntry>> deviceEntryMap, MPPQueryContext mppQueryContext) {
        Throwable t = null;
        long queryId = SessionManager.getInstance().requestQueryId();
        Set<Long> queryIdSet = null;
        if (!TreeViewSchema.isTreeViewTable((TsTable)tableInstance) && Objects.nonNull(statement.getPartitionKeyList())) {
            queryIdSet = this.attributeGuard.addFetchQueryId(queryId);
        }
        try {
            ExecutionResult executionResult = this.coordinator.executeForTableModel(statement, this.relationSqlParser, SessionManager.getInstance().getCurrSession(), queryId, mppQueryContext == null ? SessionManager.getInstance().getSessionInfo(SessionManager.getInstance().getCurrSession()) : mppQueryContext.getSession(), String.format("fetch device for query %s : %s", mppQueryContext == null ? "unknown" : mppQueryContext.getQueryId(), mppQueryContext == null ? "unknown" : mppQueryContext.getSql()), LocalExecutionPlanner.getInstance().metadata, mppQueryContext.getTimeOut() - (System.currentTimeMillis() - mppQueryContext.getStartTime()), false);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException(executionResult.status.getMessage(), executionResult.status.getCode());
            }
            List<ColumnHeader> columnHeaderList = this.coordinator.getQueryExecution(queryId).getDatasetHeader().getColumnHeaders();
            while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                Optional<TsBlock> tsBlock;
                try {
                    tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                }
                catch (IoTDBException e) {
                    t = e;
                    throw new IoTDBRuntimeException(String.format("Fetch Table Device Schema failed because %s", e.getMessage()), e.getErrorCode(), e.isUserException());
                }
                if (!tsBlock.isPresent()) break;
                if (tsBlock.get().isEmpty()) {
                    break;
                }
                if (!TreeViewSchema.isTreeViewTable((TsTable)tableInstance)) {
                    this.constructTableResults(tsBlock.get(), columnHeaderList, tableInstance, statement, mppQueryContext, attributeColumns, deviceEntryMap.get(database));
                    continue;
                }
                this.constructTreeResults(tsBlock.get(), columnHeaderList, tableInstance, mppQueryContext, deviceEntryMap);
            }
        }
        catch (Throwable throwable) {
            t = throwable;
            throw throwable;
        }
        finally {
            if (Objects.nonNull(queryIdSet)) {
                queryIdSet.remove(queryId);
                this.attributeGuard.tryUpdateCache();
            }
            this.coordinator.cleanupQueryExecution(queryId, null, t);
        }
    }

    private void constructTableResults(TsBlock tsBlock, List<ColumnHeader> columnHeaderList, TsTable tableInstance, ShowDevice statement, MPPQueryContext mppQueryContext, List<String> attributeColumns, List<DeviceEntry> deviceEntryList) {
        Column[] columns = tsBlock.getValueColumns();
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            String[] nodes = new String[tableInstance.getTagNum() + 1];
            HashMap<String, Binary> attributeMap = new HashMap<String, Binary>();
            this.constructNodsArrayAndAttributeMap(attributeMap, nodes, tableInstance.getTableName(), columnHeaderList, columns, tableInstance, i);
            IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(nodes);
            AlignedDeviceEntry deviceEntry = new AlignedDeviceEntry(deviceID, (Binary[])attributeColumns.stream().map(attributeMap::get).toArray(Binary[]::new));
            mppQueryContext.reserveMemoryForFrontEnd(deviceEntry.ramBytesUsed());
            deviceEntryList.add(deviceEntry);
            if (!Objects.nonNull(statement.getPartitionKeyList())) continue;
            this.cache.putAttributes(statement.getDatabase(), deviceID, attributeMap);
        }
    }

    private void constructTreeResults(TsBlock tsBlock, List<ColumnHeader> columnHeaderList, TsTable tableInstance, MPPQueryContext mppQueryContext, Map<String, List<DeviceEntry>> deviceEntryMap) {
        Column[] columns = tsBlock.getValueColumns();
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            String[] nodes = new String[tableInstance.getTagNum()];
            this.constructNodsArrayAndAttributeMap(Collections.emptyMap(), nodes, null, columnHeaderList, columns, tableInstance, i);
            IDeviceID deviceID = DataNodeTreeViewSchemaUtils.convertToIDeviceID(tableInstance, nodes);
            DeviceEntry deviceEntry = columns[columns.length - 2].getBoolean(i) ? new AlignedDeviceEntry(deviceID, new Binary[0]) : new NonAlignedDeviceEntry(deviceID, new Binary[0]);
            mppQueryContext.reserveMemoryForFrontEnd(deviceEntry.ramBytesUsed());
            deviceEntryMap.computeIfAbsent(columns[columns.length - 1].getBinary(0).getStringValue(TSFileConfig.STRING_CHARSET), k -> new ArrayList()).add(deviceEntry);
        }
    }

    private void constructNodsArrayAndAttributeMap(Map<String, Binary> attributeMap, String[] nodes, String tableName, List<ColumnHeader> columnHeaderList, Column[] columns, TsTable tableInstance, int rowIndex) {
        int currentIndex;
        if (Objects.nonNull(tableName)) {
            nodes[0] = tableName;
            currentIndex = 1;
        } else {
            currentIndex = 0;
        }
        for (int j = 0; j < columnHeaderList.size(); ++j) {
            TsTableColumnSchema columnSchema = tableInstance.getColumnSchema(columnHeaderList.get(j).getColumnName());
            if (columnSchema == null) continue;
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                nodes[currentIndex] = columns[j].isNull(rowIndex) ? null : columns[j].getBinary(rowIndex).getStringValue(TSFileConfig.STRING_CHARSET);
                ++currentIndex;
                continue;
            }
            if (columns[j].isNull(rowIndex)) continue;
            attributeMap.put(columnSchema.getColumnName(), columns[j].getBinary(rowIndex));
        }
    }

    private static class TableDeviceSchemaFetcherHolder {
        private static final TableDeviceSchemaFetcher INSTANCE = new TableDeviceSchemaFetcher();

        private TableDeviceSchemaFetcherHolder() {
        }
    }
}

