/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.AbstractParameter;
import org.apache.jackrabbit.standalone.cli.Argument;
import org.apache.jackrabbit.standalone.cli.CommandLine;
import org.apache.jackrabbit.standalone.cli.CommandLineFactory;
import org.apache.jackrabbit.standalone.cli.ConfigurationException;
import org.apache.jackrabbit.standalone.cli.Flag;
import org.apache.jackrabbit.standalone.cli.JcrParserException;
import org.apache.jackrabbit.standalone.cli.Option;

public class JcrParser {
    private static Log log = LogFactory.getLog(JcrParser.class);
    private Catalog catalog = CatalogFactoryBase.getInstance().getCatalog();
    private Command cmd;
    private CommandLine cl;

    public void parse(String input) throws JcrParserException, ConfigurationException {
        this.cl = null;
        this.cmd = null;
        if (input == null || input.length() == 0) {
            throw new JcrParserException("exception.parse.input.empty");
        }
        LinkedList args = this.getArguments(input);
        String cmdName = (String)args.getFirst();
        args.removeFirst();
        this.cl = CommandLineFactory.getInstance().getCommandLine(cmdName);
        this.populate(this.cl, args);
        this.validate(this.cl);
        String impl = this.cl.getImpl();
        if (impl == null) {
            impl = this.cl.getName();
        }
        this.cmd = this.catalog.getCommand(impl);
        if (this.cmd == null) {
            throw new JcrParserException("no chain command for name " + impl);
        }
    }

    private LinkedList getArguments(String input) {
        LinkedList<String> args = new LinkedList<String>();
        int length = input.length();
        boolean insideSingleQuote = false;
        boolean insideDoubleQuote = false;
        int escape = -1;
        StringBuffer arg = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (!insideSingleQuote && !insideDoubleQuote && Character.isWhitespace(c)) {
                if (arg.toString().trim().length() <= 0) continue;
                args.add(arg.toString().trim());
                arg = new StringBuffer();
                continue;
            }
            if (i == escape) {
                arg.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = i + 1;
                    continue block5;
                }
                case '\"': {
                    insideDoubleQuote = !insideDoubleQuote;
                    continue block5;
                }
                case '\'': {
                    insideSingleQuote = !insideSingleQuote;
                    continue block5;
                }
                default: {
                    arg.append(c);
                }
            }
        }
        if (arg.toString().trim().length() > 0) {
            args.add(arg.toString());
        }
        return args;
    }

    public void populateContext(Context ctx) {
        Iterator iter = this.cl.getAllParameters();
        while (iter.hasNext()) {
            AbstractParameter param = (AbstractParameter)iter.next();
            log.debug("add ctx attr: " + param.getContextKey() + "=" + param.getValue());
            ctx.put(param.getContextKey(), param.getValue());
        }
    }

    public void depopulateContext(Context ctx) {
        Iterator iter = this.cl.getAllParameters();
        while (iter.hasNext()) {
            AbstractParameter param = (AbstractParameter)iter.next();
            String ctxKey = param.getContextKey();
            log.debug("remove ctx attr: " + ctxKey + "=" + param.getValue());
            ctx.remove(ctxKey);
        }
    }

    public Command getCommand() {
        return this.cmd;
    }

    private void populate(CommandLine cl, List valList) throws JcrParserException {
        String[] values = valList.toArray(new String[valList.size()]);
        Map options = cl.getOptions();
        Map flags = cl.getFlags();
        Map clArgs = cl.getArguments();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value.startsWith("-")) {
                if (i + 1 < values.length && !values[i + 1].startsWith("-")) {
                    Option opt = (Option)options.get(value.substring(1));
                    if (opt == null) {
                        throw new JcrParserException("exception.no.opt.for.name", new String[]{value.substring(1)});
                    }
                    opt.setValue(values[i + 1]);
                    ++i;
                    continue;
                }
                Flag flag = (Flag)flags.get(value.substring(1));
                if (flag == null) {
                    throw new JcrParserException("exception.no.flag.for.name", new String[]{value});
                }
                flag.setPresent(true);
                continue;
            }
            args.add(value);
        }
        String[] argValues = args.toArray(new String[args.size()]);
        for (int j = 0; j < argValues.length; ++j) {
            Argument arg = (Argument)clArgs.get(new Integer(j));
            if (arg == null) {
                throw new JcrParserException("exception.more.arguments.than.expected");
            }
            arg.setValue(argValues[j]);
        }
    }

    private void validate(CommandLine cl) throws JcrParserException {
        Iterator iter = cl.getRequiredParameters();
        while (iter.hasNext()) {
            AbstractParameter param = (AbstractParameter)iter.next();
            if (param.getValue() != null) continue;
            throw new JcrParserException("exception.missing.paramater", new String[]{param.getName()});
        }
    }

    static {
        try {
            ConfigParser parser = new ConfigParser();
            parser.parse(JcrParser.class.getResource("command.xml"));
        }
        catch (Exception e) {
            log.error("Failed to parse command.xml", e);
        }
    }
}

