/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TailStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp3.AudioFrame;
import org.apache.tika.parser.mp3.CompositeTagHandler;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v1Handler;
import org.apache.tika.parser.mp3.ID3v22Handler;
import org.apache.tika.parser.mp3.ID3v23Handler;
import org.apache.tika.parser.mp3.ID3v24Handler;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.apache.tika.parser.mp3.LyricsHandler;
import org.apache.tika.parser.mp3.MP3Frame;
import org.apache.tika.parser.mp3.MpegStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Mp3Parser
extends AbstractParser {
    private static final long serialVersionUID = 8537074922934844370L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.audio("mpeg"));

    protected static ID3TagsAndAudio getAllTagHandlers(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        MP3Frame f;
        ID3v24Handler v24 = null;
        ID3v23Handler v23 = null;
        ID3v22Handler v22 = null;
        ID3v1Handler v1 = null;
        LyricsHandler lyrics = null;
        AudioFrame firstAudio = null;
        TailStream tailStream = new TailStream(stream, 10368);
        MpegStream mpegStream = new MpegStream(tailStream);
        while ((f = ID3v2Frame.createFrameIfPresent(mpegStream)) != null) {
            if (!(f instanceof ID3v2Frame)) continue;
            ID3v2Frame id3F = (ID3v2Frame)f;
            if (id3F.getMajorVersion() == 4) {
                v24 = new ID3v24Handler(id3F);
                continue;
            }
            if (id3F.getMajorVersion() == 3) {
                v23 = new ID3v23Handler(id3F);
                continue;
            }
            if (id3F.getMajorVersion() != 2) continue;
            v22 = new ID3v22Handler(id3F);
        }
        AudioFrame frame = mpegStream.nextFrame();
        float duration = 0.0f;
        boolean skipped = true;
        while (frame != null && skipped) {
            duration += frame.getDuration();
            if (firstAudio == null) {
                firstAudio = frame;
            }
            if (!(skipped = mpegStream.skipFrame())) continue;
            frame = mpegStream.nextFrame();
        }
        lyrics = new LyricsHandler(tailStream.getTail());
        v1 = lyrics.id3v1;
        ArrayList<ID3Tags> tags = new ArrayList<ID3Tags>();
        if (v24 != null && v24.getTagsPresent()) {
            tags.add(v24);
        }
        if (v23 != null && v23.getTagsPresent()) {
            tags.add(v23);
        }
        if (v22 != null && v22.getTagsPresent()) {
            tags.add(v22);
        }
        if (v1 != null && v1.getTagsPresent()) {
            tags.add(v1);
        }
        ID3TagsAndAudio ret = new ID3TagsAndAudio();
        ret.audio = firstAudio;
        ret.lyrics = lyrics;
        ID3TagsAndAudio.access$202(ret, tags.toArray(new ID3Tags[0]));
        ret.duration = duration;
        return ret;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "audio/mpeg");
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "MP3");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        ID3TagsAndAudio audioAndTags = Mp3Parser.getAllTagHandlers(stream, handler);
        if (audioAndTags.duration > 0.0f) {
            metadata.set(XMPDM.DURATION, audioAndTags.durationSeconds());
        }
        if (audioAndTags.audio != null) {
            metadata.set("samplerate", String.valueOf(audioAndTags.audio.getSampleRate()));
            metadata.set("channels", String.valueOf(audioAndTags.audio.getChannels()));
            metadata.set("version", audioAndTags.audio.getVersion());
            metadata.set(XMPDM.AUDIO_SAMPLE_RATE, Integer.toString(audioAndTags.audio.getSampleRate()));
            if (audioAndTags.audio.getChannels() == 1) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
            } else if (audioAndTags.audio.getChannels() == 2) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
            } else if (audioAndTags.audio.getChannels() == 5) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "5.1");
            } else if (audioAndTags.audio.getChannels() == 7) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "7.1");
            }
        }
        xhtml.startDocument();
        ArrayList<String> comments = new ArrayList<String>();
        if (audioAndTags.tags.length > 0) {
            CompositeTagHandler tag = new CompositeTagHandler(audioAndTags.tags);
            metadata.set(TikaCoreProperties.TITLE, tag.getTitle());
            metadata.set(TikaCoreProperties.CREATOR, tag.getArtist());
            metadata.set(XMPDM.ARTIST, tag.getArtist());
            metadata.set(XMPDM.ALBUM_ARTIST, tag.getAlbumArtist());
            metadata.set(XMPDM.COMPOSER, tag.getComposer());
            metadata.set(XMPDM.ALBUM, tag.getAlbum());
            metadata.set(XMPDM.COMPILATION, tag.getCompilation());
            metadata.set(XMPDM.RELEASE_DATE, tag.getYear());
            metadata.set(XMPDM.GENRE, tag.getGenre());
            for (ID3Tags.ID3Comment comment : tag.getComments()) {
                StringBuffer cmt = new StringBuffer();
                if (comment.getLanguage() != null) {
                    cmt.append(comment.getLanguage());
                    cmt.append(" - ");
                }
                if (comment.getDescription() != null) {
                    cmt.append(comment.getDescription());
                    if (comment.getText() != null) {
                        cmt.append("\n");
                    }
                }
                if (comment.getText() != null) {
                    cmt.append(comment.getText());
                }
                comments.add(cmt.toString());
                metadata.add(XMPDM.LOG_COMMENT.getName(), cmt.toString());
            }
            StringBuilder sb = new StringBuilder();
            sb.append(tag.getAlbum());
            if (tag.getTrackNumber() != null) {
                sb.append(", track ").append(tag.getTrackNumber());
                metadata.set(XMPDM.TRACK_NUMBER, tag.getTrackNumber());
            }
            if (tag.getDisc() != null) {
                sb.append(", disc ").append(tag.getDisc());
                metadata.set(XMPDM.DISC_NUMBER, tag.getDisc());
            }
            xhtml.element("h1", tag.getTitle());
            xhtml.element("p", tag.getArtist());
            xhtml.element("p", sb.toString());
            xhtml.element("p", tag.getYear());
            xhtml.element("p", tag.getGenre());
        }
        xhtml.element("p", String.valueOf(audioAndTags.durationSeconds()));
        for (String comment : comments) {
            xhtml.element("p", comment);
        }
        if (audioAndTags.lyrics != null && audioAndTags.lyrics.hasLyrics()) {
            xhtml.startElement("p", "class", "lyrics");
            xhtml.characters(((ID3TagsAndAudio)audioAndTags).lyrics.lyricsText);
            xhtml.endElement("p");
        }
        xhtml.endDocument();
    }

    @Field
    public void setMaxRecordSize(int maxRecordSize) {
        ID3v2Frame.setMaxRecordSize(maxRecordSize);
    }

    protected static class ID3TagsAndAudio {
        private ID3Tags[] tags;
        private AudioFrame audio;
        private LyricsHandler lyrics;
        private float duration;

        protected ID3TagsAndAudio() {
        }

        private float durationSeconds() {
            return this.duration / 1000.0f;
        }

        static /* synthetic */ ID3Tags[] access$202(ID3TagsAndAudio x0, ID3Tags[] x1) {
            x0.tags = x1;
            return x1;
        }
    }
}

