/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.QuadAccSink;

public class QuadDataAccSink
extends QuadAccSink {
    public QuadDataAccSink(Sink<Quad> sink) {
        super(sink);
    }

    @Override
    protected void check(Triple triple) {
        this.check(this.getGraph(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    protected void check(Quad quad) {
        this.check(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    private void check(Node g, Node s, Node p, Node o) {
        if (this.templateOnly(g) || this.templateOnly(s) || this.templateOnly(p) || this.templateOnly(o)) {
            throw new QueryParseException("Variables not permitted in data", -1, -1);
        }
        if (s.isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in data", -1, -1);
        }
    }

    private boolean templateOnly(Node n) {
        return !n.isConcrete();
    }
}

