/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import java.net.BindException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.FusekiMain;

public class FusekiMainRunner {
    public static FusekiServer runAsync(String ... args) {
        FusekiServer server = FusekiMainRunner.construct(args);
        try {
            return server.start();
        }
        catch (FusekiException ex) {
            if (ex.getCause() instanceof BindException) {
                Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port in use");
                System.exit(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
    }

    public static void run(String ... args) {
        FusekiServer server = FusekiMainRunner.runAsync(args);
        server.join();
    }

    public static FusekiServer construct(String ... args) {
        FusekiServer.Builder builder = FusekiMainRunner.builder(args);
        return builder.build();
    }

    public static FusekiServer.Builder builder(String ... args) {
        return FusekiMain.builder(args);
    }
}

