/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import java.util.Objects;
import org.apache.jena.geosparql.configuration.SrsException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;

public class CoordinatePair {
    private final Coordinate coord1;
    private final Coordinate coord2;
    private final boolean equal;

    public CoordinatePair(Coordinate coord1, Coordinate coord2) {
        this.coord1 = coord1;
        this.coord2 = coord2;
        this.equal = coord1.equals2D(coord2);
    }

    public Coordinate getCoord1() {
        return this.coord1;
    }

    public Coordinate getCoord2() {
        return this.coord2;
    }

    public boolean isEqual() {
        return this.equal;
    }

    public String toString() {
        return "CoordinatePair{coord1=" + String.valueOf(this.coord1) + ", coord2=" + String.valueOf(this.coord2) + ", equal=" + this.equal + "}";
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.coord1);
        hash = 97 * hash + Objects.hashCode(this.coord2);
        hash = 97 * hash + (this.equal ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinatePair other = (CoordinatePair)obj;
        if (this.equal != other.equal) {
            return false;
        }
        if (!Objects.equals(this.coord1, other.coord1)) {
            return false;
        }
        return Objects.equals(this.coord2, other.coord2);
    }

    public static final CoordinatePair findNearestPair(GeometryWrapper sourceGeometry, GeometryWrapper targetGeometry) throws SrsException {
        Geometry adjustedTarget;
        Geometry adjustedSource;
        SRSInfo sourceSRSInfo = sourceGeometry.getSrsInfo();
        SRSInfo targetSRSInfo = targetGeometry.getSrsInfo();
        if (!(sourceSRSInfo.isGeographic().booleanValue() && targetSRSInfo.isGeographic().booleanValue() && sourceSRSInfo.getSrsURI().equals(targetSRSInfo.getSrsURI()))) {
            throw new SrsException("Expected same Geographic SRS for GeometryWrappers. " + String.valueOf(sourceGeometry) + " : " + String.valueOf(targetGeometry));
        }
        Point point1 = null;
        Point point2 = null;
        Geometry sourceXYGeometry = sourceGeometry.getXYGeometry();
        Geometry targetXYGeometry = targetGeometry.getXYGeometry();
        if (sourceXYGeometry instanceof Point) {
            point1 = (Point)sourceXYGeometry;
        }
        if (targetXYGeometry instanceof Point) {
            point2 = (Point)targetXYGeometry;
        }
        if (point1 != null && point2 != null) {
            return new CoordinatePair(point1.getCoordinate(), point2.getCoordinate());
        }
        Envelope sourceEnvelope = sourceGeometry.getEnvelope();
        Envelope targetEnvelope = targetGeometry.getEnvelope();
        double domainRange = sourceSRSInfo.getDomainRangeX();
        double halfRange = domainRange / 2.0;
        double diff = targetEnvelope.getMaxX() - sourceEnvelope.getMinX();
        if (diff > halfRange) {
            adjustedSource = sourceGeometry.translateXYGeometry();
            adjustedTarget = targetXYGeometry;
        } else if (diff < -halfRange) {
            adjustedSource = sourceXYGeometry;
            adjustedTarget = targetGeometry.translateXYGeometry();
        } else {
            adjustedSource = sourceXYGeometry;
            adjustedTarget = targetXYGeometry;
        }
        DistanceOp distanceOp = new DistanceOp(adjustedSource, adjustedTarget);
        Coordinate[] nearest = distanceOp.nearestPoints();
        return new CoordinatePair(nearest[0], nearest[1]);
    }
}

