/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;

public class QueryIterExtendByVar
extends QueryIter {
    private Binding binding;
    private Var var;
    private Iterator<Node> members;

    public QueryIterExtendByVar(Binding binding, Var var, Iterator<Node> members, ExecutionContext execCxt) {
        super(execCxt);
        if (binding.contains(var)) {
            throw new ARQInternalErrorException("Var " + String.valueOf(var) + " already set in " + String.valueOf(binding));
        }
        this.binding = binding;
        this.var = var;
        this.members = members;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.members.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        Node n = this.members.next();
        Binding b = BindingFactory.binding(this.binding, this.var, n);
        return b;
    }

    @Override
    protected void closeIterator() {
        Iter.close(this.members);
    }

    @Override
    protected void requestCancel() {
    }
}

