/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.PrintSerializableBase;

public class ProcedurePF
extends PrintSerializableBase
implements Procedure {
    private PropertyFunction propFunc;
    private PropFuncArg subjArg;
    private PropFuncArg objArg;
    private Node pfNode;

    public ProcedurePF(PropertyFunction propFunc, PropFuncArg subjArg, Node pfNode, PropFuncArg objArg) {
        this.propFunc = propFunc;
        this.subjArg = subjArg;
        this.pfNode = pfNode;
        this.objArg = objArg;
    }

    @Override
    public QueryIterator proc(QueryIterator input, ExecutionContext execCxt) {
        return this.propFunc.exec(input, this.subjArg, this.pfNode, this.objArg, execCxt);
    }

    @Override
    public void build(Node procId, ExprList args, ExecutionContext execCxt) {
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("ProcedurePF [" + FmtUtils.stringForNode(this.pfNode, sCxt) + "]");
        out.print("[");
        this.subjArg.output(out, sCxt);
        out.print("][");
        this.objArg.output(out, sCxt);
        out.print("]");
        out.println();
    }
}

