/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;

@IgnoreRandomChains(reason="Cannot correct offsets when a char filter had changed them")
public final class WordDelimiterGraphFilter
extends TokenFilter {
    public static final int GENERATE_WORD_PARTS = 1;
    public static final int GENERATE_NUMBER_PARTS = 2;
    public static final int CATENATE_WORDS = 4;
    public static final int CATENATE_NUMBERS = 8;
    public static final int CATENATE_ALL = 16;
    public static final int PRESERVE_ORIGINAL = 32;
    public static final int SPLIT_ON_CASE_CHANGE = 64;
    public static final int SPLIT_ON_NUMERICS = 128;
    public static final int STEM_ENGLISH_POSSESSIVE = 256;
    public static final int IGNORE_KEYWORDS = 512;
    final CharArraySet protWords;
    private final int flags;
    private int[] bufferedParts = new int[16];
    private int bufferedLen;
    private int bufferedPos;
    private char[][] bufferedTermParts = new char[4][];
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttribute = this.addAttribute(KeywordAttribute.class);
    private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAttribute = this.addAttribute(PositionLengthAttribute.class);
    private final WordDelimiterIterator iterator;
    private final WordDelimiterConcatenation concat = new WordDelimiterConcatenation();
    private final boolean adjustInternalOffsets;
    private int lastConcatCount;
    private final WordDelimiterConcatenation concatAll = new WordDelimiterConcatenation();
    private int accumPosInc;
    private char[] savedTermBuffer = new char[16];
    private int savedTermLength;
    private int savedStartOffset;
    private int savedEndOffset;
    private AttributeSource.State savedState;
    private int lastStartOffset;
    private boolean adjustingOffsets;
    private int wordPos;
    final PositionSorter sorter = new PositionSorter();

    public WordDelimiterGraphFilter(TokenStream in, boolean adjustInternalOffsets, byte[] charTypeTable, int configurationFlags, CharArraySet protWords) {
        super(in);
        if ((configurationFlags & 0xFFFFFC00) != 0) {
            throw new IllegalArgumentException("flags contains unrecognized flag: " + configurationFlags);
        }
        this.flags = configurationFlags;
        this.protWords = protWords;
        this.iterator = new WordDelimiterIterator(charTypeTable, this.has(64), this.has(128), this.has(256));
        this.adjustInternalOffsets = adjustInternalOffsets;
    }

    public WordDelimiterGraphFilter(TokenStream in, int configurationFlags, CharArraySet protWords) {
        this(in, false, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, configurationFlags, protWords);
    }

    private void bufferWordParts() throws IOException {
        this.saveState();
        this.adjustingOffsets = this.adjustInternalOffsets && this.savedEndOffset - this.savedStartOffset == this.savedTermLength;
        this.bufferedLen = 0;
        this.lastConcatCount = 0;
        this.wordPos = 0;
        if (this.has(32)) {
            this.buffer(0, 1, 0, this.savedTermLength);
        }
        if (this.iterator.isSingleWord()) {
            this.buffer(this.wordPos, this.wordPos + 1, this.iterator.current, this.iterator.end);
            ++this.wordPos;
            this.iterator.next();
        } else {
            while (this.iterator.end != -1) {
                int wordType = this.iterator.type();
                if (this.concat.isNotEmpty() && (this.concat.type & wordType) == 0) {
                    this.flushConcatenation(this.concat);
                }
                if (this.shouldConcatenate(wordType)) {
                    this.concatenate(this.concat);
                }
                if (this.has(16)) {
                    this.concatenate(this.concatAll);
                }
                if (this.shouldGenerateParts(wordType)) {
                    this.buffer(this.wordPos, this.wordPos + 1, this.iterator.current, this.iterator.end);
                    ++this.wordPos;
                }
                this.iterator.next();
            }
            if (this.concat.isNotEmpty()) {
                this.flushConcatenation(this.concat);
            }
            if (this.concatAll.isNotEmpty()) {
                if (this.concatAll.subwordCount > this.lastConcatCount) {
                    if (this.wordPos == this.concatAll.startPos) {
                        ++this.wordPos;
                    }
                    this.concatAll.write();
                }
                this.concatAll.clear();
            }
        }
        if (this.has(32)) {
            if (this.wordPos == 0) {
                // empty if block
            }
            this.bufferedParts[1] = ++this.wordPos;
        }
        this.sorter.sort(this.has(32) ? 1 : 0, this.bufferedLen);
        this.wordPos = 0;
        this.bufferedPos = 0;
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (true) {
            if (this.savedState == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                if (this.has(512) && this.keywordAttribute.isKeyword()) {
                    return true;
                }
                int termLength = this.termAttribute.length();
                char[] termBuffer = this.termAttribute.buffer();
                this.accumPosInc += this.posIncAttribute.getPositionIncrement();
                this.iterator.setText(termBuffer, termLength);
                this.iterator.next();
                if (this.iterator.current == 0 && this.iterator.end == termLength || this.protWords != null && this.protWords.contains(termBuffer, 0, termLength)) {
                    this.posIncAttribute.setPositionIncrement(this.accumPosInc);
                    this.accumPosInc = 0;
                    return true;
                }
                if (this.iterator.end == -1) {
                    if (!this.has(32)) continue;
                    this.accumPosInc = 0;
                    return true;
                }
                this.bufferWordParts();
            }
            if (this.bufferedPos < this.bufferedLen) {
                int endOffset;
                int startOffset;
                this.clearAttributes();
                this.restoreState(this.savedState);
                char[] termPart = this.bufferedTermParts[this.bufferedPos];
                int startPos = this.bufferedParts[4 * this.bufferedPos];
                int endPos = this.bufferedParts[4 * this.bufferedPos + 1];
                int startPart = this.bufferedParts[4 * this.bufferedPos + 2];
                int endPart = this.bufferedParts[4 * this.bufferedPos + 3];
                ++this.bufferedPos;
                if (!this.adjustingOffsets) {
                    startOffset = this.savedStartOffset;
                    endOffset = this.savedEndOffset;
                } else {
                    startOffset = this.savedStartOffset + startPart;
                    endOffset = this.savedStartOffset + endPart;
                }
                startOffset = Math.max(startOffset, this.lastStartOffset);
                endOffset = Math.max(endOffset, this.lastStartOffset);
                this.offsetAttribute.setOffset(startOffset, endOffset);
                this.lastStartOffset = startOffset;
                if (termPart == null) {
                    this.termAttribute.copyBuffer(this.savedTermBuffer, startPart, endPart - startPart);
                } else {
                    this.termAttribute.copyBuffer(termPart, 0, termPart.length);
                }
                this.posIncAttribute.setPositionIncrement(this.accumPosInc + startPos - this.wordPos);
                this.accumPosInc = 0;
                this.posLenAttribute.setPositionLength(endPos - startPos);
                this.wordPos = startPos;
                return true;
            }
            this.savedState = null;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.accumPosInc = 0;
        this.savedState = null;
        this.lastStartOffset = 0;
        this.concat.clear();
        this.concatAll.clear();
    }

    void buffer(int startPos, int endPos, int startPart, int endPart) {
        this.buffer(null, startPos, endPos, startPart, endPart);
    }

    void buffer(char[] termPart, int startPos, int endPos, int startPart, int endPart) {
        assert (endPos > startPos) : "startPos=" + startPos + " endPos=" + endPos;
        assert (endPart > startPart || endPart == 0 && startPart == 0 && this.savedTermLength == 0) : "startPart=" + startPart + " endPart=" + endPart;
        if ((this.bufferedLen + 1) * 4 > this.bufferedParts.length) {
            this.bufferedParts = ArrayUtil.grow(this.bufferedParts, (this.bufferedLen + 1) * 4);
        }
        if (this.bufferedTermParts.length == this.bufferedLen) {
            int newSize = ArrayUtil.oversize(this.bufferedLen + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            char[][] newArray = new char[newSize][];
            System.arraycopy(this.bufferedTermParts, 0, newArray, 0, this.bufferedTermParts.length);
            this.bufferedTermParts = newArray;
        }
        this.bufferedTermParts[this.bufferedLen] = termPart;
        this.bufferedParts[this.bufferedLen * 4] = startPos;
        this.bufferedParts[this.bufferedLen * 4 + 1] = endPos;
        this.bufferedParts[this.bufferedLen * 4 + 2] = startPart;
        this.bufferedParts[this.bufferedLen * 4 + 3] = endPart;
        ++this.bufferedLen;
    }

    private void saveState() {
        this.savedTermLength = this.termAttribute.length();
        this.savedStartOffset = this.offsetAttribute.startOffset();
        this.savedEndOffset = this.offsetAttribute.endOffset();
        this.savedState = this.captureState();
        if (this.savedTermBuffer.length < this.savedTermLength) {
            this.savedTermBuffer = new char[ArrayUtil.oversize(this.savedTermLength, 2)];
        }
        System.arraycopy(this.termAttribute.buffer(), 0, this.savedTermBuffer, 0, this.savedTermLength);
    }

    private void flushConcatenation(WordDelimiterConcatenation concat2) {
        if (this.wordPos == concat2.startPos) {
            ++this.wordPos;
        }
        this.lastConcatCount = concat2.subwordCount;
        if (concat2.subwordCount != 1 || !this.shouldGenerateParts(concat2.type)) {
            concat2.write();
        }
        concat2.clear();
    }

    private boolean shouldConcatenate(int wordType) {
        return this.has(4) && WordDelimiterIterator.isAlpha(wordType) || this.has(8) && WordDelimiterIterator.isDigit(wordType);
    }

    private boolean shouldGenerateParts(int wordType) {
        return this.has(1) && WordDelimiterIterator.isAlpha(wordType) || this.has(2) && WordDelimiterIterator.isDigit(wordType);
    }

    private void concatenate(WordDelimiterConcatenation concatenation) {
        if (concatenation.isEmpty()) {
            concatenation.type = this.iterator.type();
            concatenation.startPart = this.iterator.current;
            concatenation.startPos = this.wordPos;
        }
        concatenation.append(this.savedTermBuffer, this.iterator.current, this.iterator.end - this.iterator.current);
        concatenation.endPart = this.iterator.end;
    }

    private boolean has(int flag) {
        return (this.flags & flag) != 0;
    }

    public static String flagsToString(int flags) {
        StringBuilder b = new StringBuilder();
        if ((flags & 1) != 0) {
            b.append("GENERATE_WORD_PARTS");
        }
        if ((flags & 2) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("GENERATE_NUMBER_PARTS");
        }
        if ((flags & 4) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("CATENATE_WORDS");
        }
        if ((flags & 8) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("CATENATE_NUMBERS");
        }
        if ((flags & 0x10) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("CATENATE_ALL");
        }
        if ((flags & 0x20) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("PRESERVE_ORIGINAL");
        }
        if ((flags & 0x40) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("SPLIT_ON_CASE_CHANGE");
        }
        if ((flags & 0x80) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("SPLIT_ON_NUMERICS");
        }
        if ((flags & 0x100) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("STEM_ENGLISH_POSSESSIVE");
        }
        return b.toString();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WordDelimiterGraphFilter(flags=");
        b.append(WordDelimiterGraphFilter.flagsToString(this.flags));
        b.append(')');
        return b.toString();
    }

    final class WordDelimiterConcatenation {
        final StringBuilder buffer = new StringBuilder();
        int startPart;
        int endPart;
        int startPos;
        int type;
        int subwordCount;

        WordDelimiterConcatenation() {
        }

        void append(char[] text, int offset, int length) {
            this.buffer.append(text, offset, length);
            ++this.subwordCount;
        }

        void write() {
            char[] termPart = new char[this.buffer.length()];
            this.buffer.getChars(0, this.buffer.length(), termPart, 0);
            WordDelimiterGraphFilter.this.buffer(termPart, this.startPos, WordDelimiterGraphFilter.this.wordPos, this.startPart, this.endPart);
        }

        boolean isEmpty() {
            return this.buffer.length() == 0;
        }

        boolean isNotEmpty() {
            return !this.isEmpty();
        }

        void clear() {
            this.buffer.setLength(0);
            this.subwordCount = 0;
            this.type = 0;
            this.endPart = 0;
            this.startPart = 0;
        }
    }

    private class PositionSorter
    extends InPlaceMergeSorter {
        private PositionSorter() {
        }

        @Override
        protected int compare(int i, int j) {
            int iOff = WordDelimiterGraphFilter.this.bufferedParts[4 * i + 2];
            int jOff = WordDelimiterGraphFilter.this.bufferedParts[4 * j + 2];
            int cmp = Integer.compare(iOff, jOff);
            if (cmp != 0) {
                return cmp;
            }
            iOff = WordDelimiterGraphFilter.this.bufferedParts[4 * i + 3];
            jOff = WordDelimiterGraphFilter.this.bufferedParts[4 * j + 3];
            return Integer.compare(jOff, iOff);
        }

        @Override
        protected void swap(int i, int j) {
            int iOffset = 4 * i;
            int jOffset = 4 * j;
            for (int x = 0; x < 4; ++x) {
                int tmp = WordDelimiterGraphFilter.this.bufferedParts[iOffset + x];
                WordDelimiterGraphFilter.this.bufferedParts[iOffset + x] = WordDelimiterGraphFilter.this.bufferedParts[jOffset + x];
                WordDelimiterGraphFilter.this.bufferedParts[jOffset + x] = tmp;
            }
            char[] tmp2 = WordDelimiterGraphFilter.this.bufferedTermParts[i];
            WordDelimiterGraphFilter.this.bufferedTermParts[i] = WordDelimiterGraphFilter.this.bufferedTermParts[j];
            WordDelimiterGraphFilter.this.bufferedTermParts[j] = tmp2;
        }
    }
}

