/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public final class SimplePatternSplitTokenizer
extends Tokenizer {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharacterRunAutomaton runDFA;
    private char[] pendingChars = new char[8];
    private int tokenUpto;
    private int pendingLimit;
    private int pendingUpto;
    private int offset;
    private int sepUpto;
    private final char[] buffer = new char[1024];
    private int bufferLimit;
    private int bufferNextRead;

    public SimplePatternSplitTokenizer(String regexp) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, regexp, 10000);
    }

    public SimplePatternSplitTokenizer(Automaton dfa) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, dfa);
    }

    public SimplePatternSplitTokenizer(AttributeFactory factory, String regexp, int determinizeWorkLimit) {
        this(factory, new RegExp(regexp).toAutomaton(determinizeWorkLimit));
    }

    public SimplePatternSplitTokenizer(AttributeFactory factory, Automaton dfa) {
        super(factory);
        if (!dfa.isDeterministic()) {
            throw new IllegalArgumentException("please determinize the incoming automaton first");
        }
        this.runDFA = new CharacterRunAutomaton(dfa, 10000);
    }

    private void fillToken(int offsetStart) {
        this.termAtt.setLength(this.tokenUpto);
        this.offsetAtt.setOffset(this.correctOffset(offsetStart), this.correctOffset(offsetStart + this.tokenUpto));
    }

    @Override
    public boolean incrementToken() throws IOException {
        int offsetStart = this.offset;
        this.clearAttributes();
        this.tokenUpto = 0;
        while (true) {
            this.sepUpto = 0;
            int ch = this.nextCodePoint();
            if (ch == -1) {
                if (this.tokenUpto > 0) {
                    this.fillToken(offsetStart);
                    return true;
                }
                return false;
            }
            int state = this.runDFA.step(0, ch);
            if (state == -1) continue;
            int lastAcceptLength = -1;
            do {
                if (!this.runDFA.isAccept(state)) continue;
                lastAcceptLength = this.sepUpto;
            } while ((ch = this.nextCodePoint()) != -1 && (state = this.runDFA.step(state, ch)) != -1);
            if (lastAcceptLength != -1) {
                int extra = this.sepUpto - lastAcceptLength;
                if (extra != 0) {
                    this.pushBack(extra);
                }
                this.tokenUpto -= lastAcceptLength;
                if (this.tokenUpto > 0) {
                    this.fillToken(offsetStart);
                    return true;
                }
                offsetStart = this.offset;
                continue;
            }
            if (ch == -1) {
                if (this.tokenUpto > 0) {
                    this.fillToken(offsetStart);
                    return true;
                }
                return false;
            }
            this.pushBack(this.sepUpto - 1);
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        int ofs = this.correctOffset(this.offset + this.pendingLimit - this.pendingUpto);
        this.offsetAtt.setOffset(ofs, ofs);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.offset = 0;
        this.pendingUpto = 0;
        this.pendingLimit = 0;
        this.sepUpto = 0;
        this.bufferNextRead = 0;
        this.bufferLimit = 0;
    }

    private void pushBack(int count) {
        this.tokenUpto -= count;
        assert (this.tokenUpto >= 0);
        if (this.pendingLimit == 0) {
            if (this.bufferLimit != -1 && this.bufferNextRead >= count) {
                this.bufferNextRead -= count;
            } else {
                if (count > this.pendingChars.length) {
                    this.pendingChars = ArrayUtil.grow(this.pendingChars, count);
                }
                System.arraycopy(this.termAtt.buffer(), this.tokenUpto, this.pendingChars, 0, count);
                this.pendingLimit = count;
            }
        } else {
            this.pendingUpto -= count;
            assert (this.pendingUpto >= 0);
        }
        this.offset -= count;
    }

    private void appendToToken(char ch) {
        char[] buffer = this.termAtt.buffer();
        if (this.tokenUpto == buffer.length) {
            buffer = this.termAtt.resizeBuffer(this.tokenUpto + 1);
        }
        buffer[this.tokenUpto++] = ch;
        ++this.sepUpto;
    }

    private int nextCodeUnit() throws IOException {
        char result;
        if (this.pendingUpto < this.pendingLimit) {
            result = this.pendingChars[this.pendingUpto++];
            if (this.pendingUpto == this.pendingLimit) {
                this.pendingUpto = 0;
                this.pendingLimit = 0;
            }
            this.appendToToken(result);
            ++this.offset;
        } else {
            if (this.bufferLimit == -1) {
                return -1;
            }
            assert (this.bufferNextRead <= this.bufferLimit) : "bufferNextRead=" + this.bufferNextRead + " bufferLimit=" + this.bufferLimit;
            if (this.bufferNextRead == this.bufferLimit) {
                this.bufferLimit = this.input.read(this.buffer, 0, this.buffer.length);
                if (this.bufferLimit == -1) {
                    return -1;
                }
                this.bufferNextRead = 0;
            }
            result = this.buffer[this.bufferNextRead++];
            ++this.offset;
            this.appendToToken(result);
        }
        return result;
    }

    private int nextCodePoint() throws IOException {
        int ch = this.nextCodeUnit();
        if (ch == -1) {
            return ch;
        }
        if (Character.isHighSurrogate((char)ch)) {
            return Character.toCodePoint((char)ch, (char)this.nextCodeUnit());
        }
        return ch;
    }
}

