/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.sql.SQLTransientException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.internal.EPSGFactoryProxy;
import org.apache.sis.referencing.util.LazySet;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class AuthorityFactories<T extends AuthorityFactory>
extends LazySet<T> {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    private static final GeodeticAuthorityFactory[] EPSG = new GeodeticAuthorityFactory[1];
    static final MultiAuthoritiesFactory ALL = new MultiAuthoritiesFactory(new AuthorityFactories<CRSAuthorityFactory>(CRSAuthorityFactory.class), new AuthorityFactories<CSAuthorityFactory>(CSAuthorityFactory.class), new AuthorityFactories<DatumAuthorityFactory>(DatumAuthorityFactory.class), new AuthorityFactories<CoordinateOperationAuthorityFactory>(CoordinateOperationAuthorityFactory.class)){
        {
            this.setLenient(true);
        }

        @Override
        public void reload() {
            AuthorityFactories.EPSG(null);
            super.reload();
        }
    };
    private final Class<T> service;

    private AuthorityFactories(Class<T> type) {
        this.service = type;
    }

    @Override
    protected Iterator<? extends T> createSourceIterator() {
        return ServiceLoader.load(this.service, Reflect.getContextClassLoader()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void EPSG(GeodeticAuthorityFactory factory) {
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            AuthorityFactories.EPSG[0] = factory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GeodeticAuthorityFactory EPSG() {
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            GeodeticAuthorityFactory factory = EPSG[0];
            if (factory == null) {
                try {
                    factory = new EPSGFactory(null);
                }
                catch (FactoryException e2) {
                    AuthorityFactories.log(e2, false);
                    factory = EPSGFactoryFallback.INSTANCE;
                }
                AuthorityFactories.EPSG[0] = factory;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GeodeticAuthorityFactory fallback(UnavailableFactoryException e2) throws UnavailableFactoryException {
        boolean isTransient = e2.getCause() instanceof SQLTransientException;
        AuthorityFactory unavailable = e2.getUnavailableFactory();
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            boolean alreadyDone;
            GeodeticAuthorityFactory factory = EPSG[0];
            boolean bl = alreadyDone = factory == EPSGFactoryFallback.INSTANCE;
            if (!alreadyDone) {
                if (unavailable != factory) {
                    throw e2;
                }
                factory = EPSGFactoryFallback.INSTANCE;
                if (!isTransient) {
                    ALL.reload();
                    AuthorityFactories.EPSG[0] = factory;
                }
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (!alreadyDone) {
                AuthorityFactories.log(e2, true);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean failure(UnavailableFactoryException e2) {
        if (e2.getCause() instanceof SQLTransientException) return true;
        AuthorityFactory unavailable = e2.getUnavailableFactory();
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            GeodeticAuthorityFactory factory = EPSG[0];
            if (factory == EPSGFactoryFallback.INSTANCE) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (unavailable != factory) return true;
            ALL.reload();
            AuthorityFactories.EPSG[0] = EPSGFactoryFallback.INSTANCE;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private static void log(Exception e2, boolean isWarning) {
        String message = e2.getMessage();
        if (message == null) {
            message = e2.toString();
        }
        LogRecord record = new LogRecord(isWarning ? Level.WARNING : Level.CONFIG, message);
        if (isWarning && !(e2 instanceof UnavailableFactoryException)) {
            record.setThrown(e2);
        }
        Logging.completeAndLog(LOGGER, CRS.class, "getAuthorityFactory", record);
    }

    @Override
    protected T[] initialValues() {
        AuthorityFactories.EPSG();
        return EPSG;
    }

    @Override
    protected T next(Iterator<? extends T> it) {
        AuthorityFactory e2 = (AuthorityFactory)it.next();
        if (e2 instanceof EPSGFactoryProxy) {
            e2 = it.hasNext() ? (AuthorityFactory)it.next() : null;
        }
        return (T)e2;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.referencing"){

            @Override
            protected void classpathChanged() {
                ALL.reload();
            }
        });
    }
}

