/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.StringUtil;

public class SessionContext {
    public static final String NULL_VHOST = "0.0.0.0";
    protected Context _context;
    protected SessionManager _sessionManager;
    protected String _workerName;
    protected String _canonicalContextPath;
    protected String _vhost;

    protected SessionContext() {
    }

    public SessionContext(SessionManager sessionManager) {
        this._sessionManager = Objects.requireNonNull(sessionManager);
        this._workerName = this._sessionManager.getSessionIdManager().getWorkerName();
        this._context = sessionManager.getContext();
        this._canonicalContextPath = this.canonicalizeContextPath(this._context);
        this._vhost = this.canonicalizeVHost(this._context);
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public Context getContext() {
        return this._context;
    }

    public String getCanonicalContextPath() {
        return this._canonicalContextPath;
    }

    public String getVhost() {
        return this._vhost;
    }

    public String toString() {
        return this._workerName + "_" + this._canonicalContextPath + "_" + this._vhost;
    }

    public void run(Runnable r) {
        if (this._context != null) {
            this._context.run(r);
        } else {
            r.run();
        }
    }

    private String canonicalizeContextPath(Context context2) {
        if (context2 == null) {
            return "";
        }
        return this.canonicalize(context2.getContextPath());
    }

    private String canonicalizeVHost(Context context2) {
        String vhost = NULL_VHOST;
        if (context2 == null) {
            return vhost;
        }
        List<String> vhosts = context2.getVirtualHosts();
        if (vhosts == null || vhosts.isEmpty()) {
            return vhost;
        }
        return vhosts.get(0);
    }

    private String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return StringUtil.sanitizeFileSystemName(path);
    }
}

