/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Position;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

public class BufferCurveSetBuilder {
    private Geometry inputGeom;
    private double distance;
    private OffsetCurveBuilder curveBuilder;
    private List curveList = new ArrayList();
    private boolean isInvertOrientation = false;
    private static final int MAX_INVERTED_RING_SIZE = 9;
    private static final int INVERTED_CURVE_VERTEX_FACTOR = 4;
    private static final double NEARNESS_FACTOR = 0.99;

    public BufferCurveSetBuilder(Geometry inputGeom, double distance, PrecisionModel precisionModel, BufferParameters bufParams) {
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.curveBuilder = new OffsetCurveBuilder(precisionModel, bufParams);
    }

    void setInvertOrientation(boolean isInvertOrientation) {
        this.isInvertOrientation = isInvertOrientation;
    }

    private boolean isRingCCW(Coordinate[] coord) {
        boolean isCCW = Orientation.isCCWArea(coord);
        if (this.isInvertOrientation) {
            return !isCCW;
        }
        return isCCW;
    }

    public List getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }

    private void addCurve(Coordinate[] coord, int leftLoc, int rightLoc) {
        if (coord == null || coord.length < 2) {
            return;
        }
        NodedSegmentString e2 = new NodedSegmentString(coord, new Label(0, 1, leftLoc, rightLoc));
        this.curveList.add(e2);
    }

    private void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (g instanceof Point) {
            this.addPoint((Point)g);
        } else if (g instanceof MultiPoint) {
            this.addCollection((MultiPoint)g);
        } else if (g instanceof MultiLineString) {
            this.addCollection((MultiLineString)g);
        } else if (g instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private void addPoint(Point p) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coord = p.getCoordinates();
        if (coord.length >= 1 && !coord[0].isValid()) {
            return;
        }
        Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
        this.addCurve(curve, 2, 0);
    }

    private void addLineString(LineString line) {
        if (this.curveBuilder.isLineOffsetEmpty(this.distance)) {
            return;
        }
        Coordinate[] coord = BufferCurveSetBuilder.clean(line.getCoordinates());
        if (CoordinateArrays.isRing(coord) && !this.curveBuilder.getBufferParameters().isSingleSided()) {
            this.addRingBothSides(coord, this.distance);
        } else {
            Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
            this.addCurve(curve, 2, 0);
        }
    }

    private static Coordinate[] clean(Coordinate[] coords) {
        return CoordinateArrays.removeRepeatedOrInvalidPoints(coords);
    }

    private void addPolygon(Polygon p) {
        double offsetDistance = this.distance;
        int offsetSide = 1;
        if (this.distance < 0.0) {
            offsetDistance = -this.distance;
            offsetSide = 2;
        }
        LinearRing shell = p.getExteriorRing();
        Coordinate[] shellCoord = BufferCurveSetBuilder.clean(shell.getCoordinates());
        if (this.distance < 0.0 && BufferCurveSetBuilder.isErodedCompletely(shell, this.distance)) {
            return;
        }
        if (this.distance <= 0.0 && shellCoord.length < 3) {
            return;
        }
        this.addRingSide(shellCoord, offsetDistance, offsetSide, 2, 0);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate[] holeCoord = BufferCurveSetBuilder.clean(hole.getCoordinates());
            if (this.distance > 0.0 && BufferCurveSetBuilder.isErodedCompletely(hole, -this.distance)) continue;
            this.addRingSide(holeCoord, offsetDistance, Position.opposite(offsetSide), 0, 2);
        }
    }

    private void addRingBothSides(Coordinate[] coord, double distance) {
        this.addRingSide(coord, distance, 1, 2, 0);
        this.addRingSide(coord, distance, 2, 0, 2);
    }

    private void addRingSide(Coordinate[] coord, double offsetDistance, int side, int cwLeftLoc, int cwRightLoc) {
        Coordinate[] curve;
        if (offsetDistance == 0.0 && coord.length < 3) {
            return;
        }
        int leftLoc = cwLeftLoc;
        int rightLoc = cwRightLoc;
        boolean isCCW = this.isRingCCW(coord);
        if (coord.length >= 3 && isCCW) {
            leftLoc = cwRightLoc;
            rightLoc = cwLeftLoc;
            side = Position.opposite(side);
        }
        if (BufferCurveSetBuilder.isRingCurveInverted(coord, offsetDistance, curve = this.curveBuilder.getRingCurve(coord, side, offsetDistance))) {
            return;
        }
        this.addCurve(curve, leftLoc, rightLoc);
    }

    private static boolean isRingCurveInverted(Coordinate[] inputRing, double distance, Coordinate[] curveRing) {
        if (distance == 0.0) {
            return false;
        }
        if (inputRing.length <= 3) {
            return false;
        }
        if (inputRing.length >= 9) {
            return false;
        }
        if (curveRing.length > 4 * inputRing.length) {
            return false;
        }
        return !BufferCurveSetBuilder.hasPointOnBuffer(inputRing, distance, curveRing);
    }

    private static boolean hasPointOnBuffer(Coordinate[] inputRing, double distance, Coordinate[] curveRing) {
        double distTol = 0.99 * Math.abs(distance);
        for (int i = 0; i < curveRing.length - 1; ++i) {
            Coordinate v = curveRing[i];
            double dist = Distance.pointToSegmentString(v, inputRing);
            if (dist > distTol) {
                return true;
            }
            int iNext = i < curveRing.length - 1 ? i + 1 : 0;
            Coordinate vnext = curveRing[iNext];
            Coordinate midPt = LineSegment.midPoint(v, vnext);
            double distMid = Distance.pointToSegmentString(midPt, inputRing);
            if (!(distMid > distTol)) continue;
            return true;
        }
        return false;
    }

    private static boolean isErodedCompletely(LinearRing ring, double bufferDistance) {
        Coordinate[] ringCoord = ring.getCoordinates();
        if (ringCoord.length < 4) {
            return bufferDistance < 0.0;
        }
        if (ringCoord.length == 4) {
            return BufferCurveSetBuilder.isTriangleErodedCompletely(ringCoord, bufferDistance);
        }
        Envelope env = ring.getEnvelopeInternal();
        double envMinDimension = Math.min(env.getHeight(), env.getWidth());
        return bufferDistance < 0.0 && 2.0 * Math.abs(bufferDistance) > envMinDimension;
    }

    private static boolean isTriangleErodedCompletely(Coordinate[] triangleCoord, double bufferDistance) {
        Triangle tri = new Triangle(triangleCoord[0], triangleCoord[1], triangleCoord[2]);
        Coordinate inCentre = tri.inCentre();
        double distToCentre = Distance.pointToSegment(inCentre, tri.p0, tri.p1);
        return distToCentre < Math.abs(bufferDistance);
    }
}

