/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.tri;

import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.triangulate.tri.TriEdge;

public class TriangulationBuilder {
    private HashMap<TriEdge, Tri> triMap = new HashMap();

    public static void build(List<? extends Tri> triList) {
        new TriangulationBuilder(triList);
    }

    private TriangulationBuilder(List<? extends Tri> triList) {
        for (Tri tri : triList) {
            this.add(tri);
        }
    }

    private Tri find(Coordinate p0, Coordinate p1) {
        TriEdge e2 = new TriEdge(p0, p1);
        return this.triMap.get(e2);
    }

    private void add(Tri tri) {
        Coordinate p0 = tri.getCoordinate(0);
        Coordinate p1 = tri.getCoordinate(1);
        Coordinate p2 = tri.getCoordinate(2);
        Tri n0 = this.find(p0, p1);
        Tri n1 = this.find(p1, p2);
        Tri n2 = this.find(p2, p0);
        tri.setAdjacent(n0, n1, n2);
        this.addAdjacent(tri, n0, p0, p1);
        this.addAdjacent(tri, n1, p1, p2);
        this.addAdjacent(tri, n2, p2, p0);
    }

    private void addAdjacent(Tri tri, Tri adj, Coordinate p0, Coordinate p1) {
        if (adj == null) {
            this.triMap.put(new TriEdge(p0, p1), tri);
            return;
        }
        adj.setAdjacent(p1, tri);
    }
}

