/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.command;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.impl.action.command.ActionCommand;
import org.jline.reader.ParsedLine;

public class ActionMaskingCallback {
    private final ActionCommand command;
    private final Set<String> booleanOptions;
    private final Map<String, Option> typedOptions;
    private final List<Argument> arguments;

    public static ActionMaskingCallback build(ActionCommand command) {
        HashSet<String> booleanOptions = new HashSet<String>();
        HashMap<String, Option> typedOptions = new HashMap<String, Option>();
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        boolean censor = false;
        for (Class<? extends Action> type = command.getActionClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                        booleanOptions.add(option.name());
                        booleanOptions.addAll(Arrays.asList(option.aliases()));
                    } else {
                        typedOptions.put(option.name(), option);
                        Arrays.asList(option.aliases()).forEach(action -> typedOptions.put(option.name(), option));
                        censor |= option.censor();
                    }
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                arguments.add(argument);
                censor |= argument.censor();
            }
        }
        arguments.sort(Comparator.comparing(Argument::index));
        return censor ? new ActionMaskingCallback(command, booleanOptions, typedOptions, arguments) : null;
    }

    private ActionMaskingCallback(ActionCommand command, Set<String> booleanOptions, Map<String, Option> typedOptions, List<Argument> arguments) {
        this.command = command;
        this.booleanOptions = booleanOptions;
        this.typedOptions = typedOptions;
        this.arguments = arguments;
    }

    public String filter(String line, ParsedLine parsed) {
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        int cur = line.indexOf(parsed.line());
        List words = parsed.words();
        int state = 0;
        int arg = 0;
        block5: for (int word = 0; word < words.size(); ++word) {
            String wordStr = (String)words.get(word);
            switch (state) {
                case 0: {
                    cur = line.indexOf(wordStr, cur) + wordStr.length();
                    ++state;
                    continue block5;
                }
                case 1: {
                    if (wordStr.startsWith("-")) {
                        Option option;
                        int idxEq = wordStr.indexOf(61);
                        if (idxEq > 0) {
                            String name = wordStr.substring(0, idxEq);
                            if (this.booleanOptions.contains(name) || (option = this.typedOptions.get(name)) == null || !option.censor()) continue block5;
                            cur = line.indexOf(wordStr, cur);
                            sb.append(line.substring(prev, cur + idxEq + 1));
                            for (int i = idxEq + 1; i < wordStr.length(); ++i) {
                                sb.append(option.mask());
                            }
                            prev = cur += wordStr.length();
                            continue block5;
                        }
                        String name = wordStr;
                        if (this.booleanOptions.contains(name) || (option = this.typedOptions.get(name)) == null || !option.censor() || ++word >= words.size()) continue block5;
                        String val = (String)words.get(word);
                        cur = line.indexOf(val, cur);
                        sb.append(line.substring(prev, cur));
                        for (int i = 0; i < val.length(); ++i) {
                            sb.append(option.mask());
                        }
                        prev = cur += val.length();
                        continue block5;
                    }
                    state = 2;
                }
                case 2: {
                    if (arg >= this.arguments.size()) continue block5;
                    Argument argument = this.arguments.get(arg);
                    if (argument.censor()) {
                        cur = line.indexOf(wordStr, cur);
                        sb.append(line.substring(prev, cur));
                        for (int i = 0; i < wordStr.length(); ++i) {
                            sb.append(argument.mask());
                        }
                        prev = cur += wordStr.length();
                    }
                    if (argument.multiValued()) continue block5;
                    ++arg;
                }
            }
        }
        if (prev < line.length()) {
            sb.append(line, prev, line.length());
        }
        return sb.toString();
    }
}

