/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.shell.ShellFactorySelector;

public class AggregateShellFactory
extends AbstractLoggingBean
implements ShellFactory,
ShellFactorySelector {
    protected final ShellFactory defaultFactory;
    protected final Collection<? extends ShellFactorySelector> selectors;

    public AggregateShellFactory(Collection<? extends ShellFactorySelector> selectors) {
        this(selectors, InteractiveProcessShellFactory.INSTANCE);
    }

    public AggregateShellFactory(Collection<? extends ShellFactorySelector> selectors, ShellFactory defaultFactory) {
        this.selectors = selectors == null ? Collections.emptyList() : selectors;
        this.defaultFactory = Objects.requireNonNull(defaultFactory, "No default factory provided");
    }

    @Override
    public Command createShell(ChannelSession channel) throws IOException {
        ShellFactory factory = this.selectShellFactory(channel);
        if (factory == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createShell({}) using default factory={}", (Object)channel, (Object)this.defaultFactory);
            }
            factory = this.defaultFactory;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("createShell({}) using selected factory={}", (Object)channel, (Object)factory);
        }
        return factory.createShell(channel);
    }

    @Override
    public ShellFactory selectShellFactory(ChannelSession channel) throws IOException {
        return ShellFactorySelector.selectShellFactory(this.selectors, channel);
    }
}

