/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.test.deploy;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.jersey.JerseyServiceDeploymentContributorBase;
import org.apache.knox.gateway.topology.Service;

public class ServiceTestDeploymentContributor
extends JerseyServiceDeploymentContributorBase {
    private static final String PACKAGES_PARAM = "jersey.config.server.provider.packages";

    public String getRole() {
        return "SERVICE-TEST";
    }

    public String getName() {
        return "service-test";
    }

    protected String[] getPackages() {
        return new String[]{"org.apache.knox.gateway.service.test"};
    }

    protected String[] getPatterns() {
        return new String[]{"*/**?**", "/*"};
    }

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        String packages = StringUtils.join((Object[])this.getPackages(), (String)";");
        for (String pattern : this.getPatterns()) {
            ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
            resource.role(service.getRole());
            resource.pattern(pattern);
            this.addXForwardedFilter(context, service, resource);
            ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
            FilterParamDescriptor param = resource.createFilterParam();
            param.name(PACKAGES_PARAM);
            param.value(packages);
            params.add(param);
            FilterParamDescriptor traceType = resource.createFilterParam();
            traceType.name("jersey.config.server.tracing");
            traceType.value("ALL");
            params.add(traceType);
            FilterParamDescriptor traceLevel = resource.createFilterParam();
            traceLevel.name("jersey.config.server.tracing.threshold");
            traceLevel.value("VERBOSE");
            params.add(traceLevel);
            context.contributeFilter(service, resource, "pivot", "jersey", params);
        }
    }
}

