/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

class CompiledSourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();
    private final String[] binaryProperties;
    private final String[] testBinaryProperties;

    public CompiledSourceForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots srcRoots, SourceRoots testRoots, String[] binaryProperties, String[] testBinaryProperties) {
        assert (helper != null);
        assert (evaluator != null);
        assert (srcRoots != null);
        assert (binaryProperties != null && binaryProperties.length > 0);
        assert (testRoots != null ? testBinaryProperties != null && testBinaryProperties.length > 0 : testBinaryProperties == null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = srcRoots;
        this.testRoots = testRoots;
        this.binaryProperties = binaryProperties;
        this.testBinaryProperties = testBinaryProperties;
    }

    @Override
    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res;
        if (FileUtil.getArchiveFile(binaryRoot) != null) {
            binaryRoot = FileUtil.getArchiveFile(binaryRoot);
        }
        if ((res = this.cache.get(binaryRoot)) != null) {
            return res;
        }
        SourceRoots src = null;
        for (String property : this.binaryProperties) {
            if (!this.hasSources(binaryRoot, property)) continue;
            src = this.sourceRoots;
            break;
        }
        if (src == null && this.testBinaryProperties != null) {
            for (String property : this.testBinaryProperties) {
                if (!this.hasSources(binaryRoot, property)) continue;
                src = this.testRoots;
                break;
            }
        }
        if (src == null) {
            return null;
        }
        res = new Result(src, src == this.sourceRoots);
        this.cache.put(binaryRoot, res);
        return res;
    }

    private boolean hasSources(URL binaryRoot, String binaryProperty) {
        try {
            String outDir = this.evaluator.getProperty(binaryProperty);
            if (outDir != null) {
                File f = this.helper.resolveFile(outDir);
                URL url = Utilities.toURI(f).toURL();
                if (!f.exists() && !f.getPath().toLowerCase().endsWith(".jar")) {
                    assert (!url.toExternalForm().endsWith("/")) : f;
                    url = new URL(url.toExternalForm() + "/");
                }
                if (url.equals(binaryRoot)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURL) {
            Exceptions.printStackTrace(malformedURL);
        }
        return false;
    }

    private class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport(this);
        private SourceRoots sourceRoots;
        private final boolean gensrc;

        public Result(SourceRoots sourceRoots, boolean gensrc) {
            this.sourceRoots = sourceRoots;
            this.sourceRoots.addPropertyChangeListener(this);
            this.gensrc = gensrc;
        }

        @Override
        public FileObject[] getRoots() {
            String buildGeneratedDirS;
            if (this.gensrc && (buildGeneratedDirS = CompiledSourceForBinaryQueryImpl.this.evaluator.getProperty("build.generated.sources.dir")) != null) {
                String apSourcesDirS = CompiledSourceForBinaryQueryImpl.this.evaluator.getProperty("annotation.processing.source.output");
                FileObject apSourcesDir = apSourcesDirS != null ? CompiledSourceForBinaryQueryImpl.this.helper.resolveFileObject(apSourcesDirS) : null;
                FileObject buildGeneratedDir = CompiledSourceForBinaryQueryImpl.this.helper.resolveFileObject(buildGeneratedDirS);
                if (buildGeneratedDir != null) {
                    ArrayList<FileObject> roots = new ArrayList<FileObject>(Arrays.asList(this.sourceRoots.getRoots()));
                    for (FileObject root : buildGeneratedDir.getChildren()) {
                        if (root.equals(apSourcesDir) || !root.isFolder()) continue;
                        roots.add(root);
                    }
                    return roots.toArray(new FileObject[0]);
                }
            }
            return this.sourceRoots.getRoots();
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                this.changeSupport.fireChange();
            }
        }
    }
}

