/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.provenance;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import org.apache.nifi.web.api.dto.provenance.ProvenanceRequestDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceResultsDTO;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

@XmlType(name="provenance")
public class ProvenanceDTO {
    private String id;
    private String uri;
    private Date submissionTime;
    private Date expiration;
    private Integer percentCompleted;
    private Boolean finished;
    private ProvenanceRequestDTO request;
    private ProvenanceResultsDTO results;

    @Schema(description="The id of the provenance query.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The URI for this query. Used for obtaining/deleting the request at a later time")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp when the query was submitted.", type="string")
    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Date submissionTime) {
        this.submissionTime = submissionTime;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp when the query will expire.", type="string")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Schema(description="The current percent complete.")
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
    }

    @Schema(description="Whether the query has finished.")
    public Boolean isFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @Schema(description="The provenance request.")
    public ProvenanceRequestDTO getRequest() {
        return this.request;
    }

    public void setRequest(ProvenanceRequestDTO request) {
        this.request = request;
    }

    @Schema(description="The provenance results.")
    public ProvenanceResultsDTO getResults() {
        return this.results;
    }

    public void setResults(ProvenanceResultsDTO results) {
        this.results = results;
    }
}

