/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output.errors;

import java.util.Optional;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.output.errors.ErrorCause;
import org.flywaydb.core.api.output.errors.ErrorOutputItem;
import org.flywaydb.core.api.output.errors.ExceptionToErrorObjectConverter;

public class FaultToErrorObjectConverter
extends ExceptionToErrorObjectConverter<Exception, FaultErrorOutputItem> {
    @Override
    public Class<Exception> getSupportedExceptionType() {
        return Exception.class;
    }

    @Override
    public FaultErrorOutputItem convert(Exception exception) {
        return new FaultErrorOutputItem(CoreErrorCode.FAULT, Optional.ofNullable(exception.getMessage()).orElse("Fault occurred"), this.getStackTrace(exception), this.getCause(exception).orElse(null));
    }

    public record FaultErrorOutputItem(ErrorCode errorCode, String message, String stackTrace, ErrorCause cause) implements ErrorOutputItem
    {
    }
}

