/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsCachedPack;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderIoStats;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;

public class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    private static final int MAX_RESOLVE_MATCHES = 256;
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    final DfsReaderIoStats.Accumulator stats = new DfsReaderIoStats.Accumulator();
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private List<PackLoadListener> packLoadListeners = new ArrayList<PackLoadListener>();
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = (a, b) -> {
        int cmp = a.packIndex - b.packIndex;
        if (cmp == 0) {
            cmp = Long.signum(a.offset - b.offset);
        }
        return cmp;
    };
    private static final Comparator<DfsPackFile> PACK_SORT_FOR_REUSE = Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.reuseComparator());

    protected DfsReader(DfsObjDatabase db) {
        this.db = db;
        this.streamFileThreshold = db.getReaderOptions().getStreamFileThreshold();
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return this.db.newReader();
    }

    @Override
    public void setAvoidUnreachableObjects(boolean avoid) {
        this.avoidUnreachable = avoid;
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (bitmapIndex != null) {
                return this.createBitmapIndex(bitmapIndex);
            }
            ++n2;
        }
        return null;
    }

    protected BitmapIndex createBitmapIndex(@NonNull PackBitmapIndex packBitmapIndex) {
        return new BitmapIndexImpl(packBitmapIndex);
    }

    @Override
    public Optional<CommitGraph> getCommitGraph() throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            CommitGraph cg = pack.getCommitGraph(this);
            if (cg != null) {
                return Optional.of(cg);
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        DfsPackFile[] dfsPackFileArray = this.db.getPacks();
        int n = dfsPackFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (needBitmap.removeAllOrNone(bitmapIndex)) {
                return Collections.singletonList(new DfsCachedPack(pack));
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        DfsObjDatabase.PackList packList = this.db.getPackList();
        this.resolveImpl(packList, id, matches);
        if (matches.size() < 256 && packList.dirty()) {
            ++this.stats.scanPacks;
            this.resolveImpl(this.db.scanPacks(packList), id, matches);
        }
        return matches;
    }

    private void resolveImpl(DfsObjDatabase.PackList packList, AbbreviatedObjectId id, HashSet<ObjectId> matches) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            if (!this.skipGarbagePack(pack)) {
                pack.resolve(this, matches, id, 256);
                if (matches.size() >= 256) break;
            }
            ++n2;
        }
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.findPack(objectId) >= 0;
    }

    private int findPack(AnyObjectId objectId) throws IOException {
        int idxPos;
        if (this.last != null && !this.skipGarbagePack(this.last) && (idxPos = this.last.findIdxPosition(this, objectId)) >= 0) {
            return idxPos;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        int idxPos2 = this.findInPackList(packList, objectId);
        if (idxPos2 >= 0) {
            return idxPos2;
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            idxPos2 = this.findInPackList(this.db.scanPacks(packList), objectId);
            return idxPos2;
        }
        return -1;
    }

    private int findInPackList(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            int idxPos;
            DfsPackFile pack = dfsPackFileArray[n2];
            if (pack != this.last && !this.skipGarbagePack(pack) && (idxPos = pack.findIdxPosition(this, objectId)) >= 0) {
                this.last = pack;
                return idxPos;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr;
        if (this.last != null && !this.skipGarbagePack(this.last) && (ldr = this.last.get(this, objectId)) != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ldr = this.openImpl(packList, objectId);
        if (ldr != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            ldr = this.openImpl(this.db.scanPacks(packList), objectId);
            if (ldr != null) {
                return DfsReader.checkType(ldr, objectId, typeHint);
            }
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private static ObjectLoader checkType(ObjectLoader ldr, AnyObjectId id, int typeHint) throws IncorrectObjectTypeException {
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(id.copy(), typeHint);
        }
        return ldr;
    }

    private ObjectLoader openImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        DfsPackFile[] dfsPackFileArray = packList.packs;
        int n = packList.packs.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectLoader ldr;
            DfsPackFile pack = dfsPackFileArray[n2];
            if (pack != this.last && !this.skipGarbagePack(pack) && (ldr = pack.get(this, objectId)) != null) {
                this.last = pack;
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<ObjectId> getShallowCommits() {
        return Collections.emptySet();
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        HashSet<ObjectId> pending = new HashSet<ObjectId>();
        for (ObjectId id : objectIds) {
            pending.add(id);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        this.findAllImpl(packList, pending, r);
        if (!pending.isEmpty() && packList.dirty()) {
            ++this.stats.scanPacks;
            this.findAllImpl(this.db.scanPacks(packList), pending, r);
        }
        for (ObjectId t : pending) {
            r.add(new FoundObject<ObjectId>(t));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        return r;
    }

    private <T extends ObjectId> void findAllImpl(DfsObjDatabase.PackList packList, HashSet<T> pending, List<FoundObject<T>> r) {
        DfsPackFile[] packs = packList.packs;
        if (packs.length == 0) {
            return;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packs[lastIdx];
        HashSet<ObjectId> toRemove = new HashSet<ObjectId>();
        block4: for (ObjectId t : pending) {
            if (!this.skipGarbagePack(lastPack)) {
                try {
                    long p = lastPack.findOffset(this, t);
                    if (0L < p) {
                        r.add(new FoundObject<ObjectId>(t, lastIdx, lastPack, p));
                        toRemove.add(t);
                        continue;
                    }
                }
                catch (IOException p) {
                    // empty catch block
                }
            }
            int i = 0;
            while (i < packs.length) {
                DfsPackFile pack;
                if (i != lastIdx && !this.skipGarbagePack(pack = packs[i])) {
                    try {
                        long p = pack.findOffset(this, t);
                        if (0L < p) {
                            r.add(new FoundObject<ObjectId>(t, i, pack, p));
                            toRemove.add(t);
                            lastIdx = i;
                            lastPack = pack;
                            continue block4;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        pending.removeAll(toRemove);
        this.last = lastPack;
    }

    private boolean skipGarbagePack(DfsPackFile pack) {
        return this.avoidUnreachable && pack.isGarbage();
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int idxPos = this.findPack(objectId);
        if (idxPos < 0) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != 3 || !this.safeHasObjectSizeIndex(this.last)) {
            return this.last.getObjectSize(this, objectId);
        }
        long sz = this.safeGetIndexedObjectSize(this.last, idxPos);
        if (sz >= 0L) {
            return sz;
        }
        return this.last.getObjectSize(this, objectId);
    }

    @Override
    public boolean isNotLargerThan(AnyObjectId objectId, int typeHint, long limit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int idxPos = this.findPack(objectId);
        if (idxPos < 0) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        ++this.stats.isNotLargerThanCallCount;
        if (typeHint != 3 || !this.safeHasObjectSizeIndex(this.last)) {
            return this.last.getObjectSize(this, objectId) <= limit;
        }
        long sz = this.safeGetIndexedObjectSize(this.last, idxPos);
        if (sz >= 0L) {
            return sz <= limit;
        }
        if (this.isLimitInsideIndexThreshold(this.last, limit)) {
            return true;
        }
        return this.last.getObjectSize(this, objectId) <= limit;
    }

    private boolean safeHasObjectSizeIndex(DfsPackFile pack) {
        try {
            return pack.hasObjectSizeIndex(this);
        }
        catch (IOException e) {
            return false;
        }
    }

    private long safeGetIndexedObjectSize(DfsPackFile pack, int idxPos) {
        long sz;
        try {
            sz = pack.getIndexedObjectSize(this, idxPos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (sz < 0L) {
            ++this.stats.objectSizeIndexMiss;
        } else {
            ++this.stats.objectSizeIndexHit;
        }
        return sz;
    }

    private boolean isLimitInsideIndexThreshold(DfsPackFile pack, long limit) {
        try {
            return (long)pack.getObjectSizeIndexThreshold(this) <= limit;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new DfsObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        List<DfsPackFile> packs = this.sortPacksForSelectRepresentation();
        this.trySelectRepresentation(packer, monitor, objects, packs, false);
        List<DfsPackFile> garbage = this.garbagePacksForSelectRepresentation();
        if (!garbage.isEmpty() && DfsReader.checkGarbagePacks(objects)) {
            this.trySelectRepresentation(packer, monitor, objects, garbage, true);
        }
    }

    private void trySelectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects, List<DfsPackFile> packs, boolean skipFound) throws IOException {
        for (DfsPackFile pack : packs) {
            List<DfsObjectToPack> inPack = pack.findAllFromPack(this, objects, skipFound);
            if (inPack.isEmpty()) continue;
            DfsObjectRepresentation rep = new DfsObjectRepresentation(pack);
            for (DfsObjectToPack otp : inPack) {
                pack.fillRepresentation(rep, otp.getOffset(), this);
                otp.setOffset(0L);
                packer.select(otp, rep);
                if (otp.isFound()) continue;
                otp.setFound();
                monitor.update(1);
            }
        }
    }

    private List<DfsPackFile> sortPacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> sorted = new ArrayList<DfsPackFile>(packs.length);
        DfsPackFile[] dfsPackFileArray = packs;
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile p = dfsPackFileArray[n2];
            if (p.getPackDescription().getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                sorted.add(p);
            }
            ++n2;
        }
        Collections.sort(sorted, PACK_SORT_FOR_REUSE);
        return sorted;
    }

    private List<DfsPackFile> garbagePacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> garbage = new ArrayList<DfsPackFile>(packs.length);
        DfsPackFile[] dfsPackFileArray = packs;
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile p = dfsPackFileArray[n2];
            if (p.getPackDescription().getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                garbage.add(p);
            }
            ++n2;
        }
        return garbage;
    }

    private static boolean checkGarbagePacks(Iterable<ObjectToPack> objects) {
        for (ObjectToPack otp : objects) {
            if (((DfsObjectToPack)otp).isFound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((DfsCachedPack)pack).copyAsIs(out, this);
    }

    int copy(BlockBasedFile file, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = file.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(file, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = file.length;
        } while (need > 0 && position < length);
        return cnt - need;
    }

    int inflate(DfsPackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        long start = System.nanoTime();
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.block.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                this.stats.inflatedBytes += (long)dstoff;
                this.stats.inflationMicros += BlockBasedFile.elapsedMicros(start);
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.block.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(BlockBasedFile file, long position) throws IOException {
        if (this.block == null || !this.block.contains(file.key, position)) {
            this.block = null;
            this.block = file.getOrLoadBlock(position, this);
        }
    }

    void unpin() {
        this.block = null;
    }

    public DfsReaderIoStats getIoStats() {
        return new DfsReaderIoStats(this.stats);
    }

    void emitIndexLoad(DfsPackDescription packDescription, PackExt ext, Object loadedIdx) {
        this.packLoadListeners.forEach(listener -> listener.onIndexLoad(packDescription.getFileName(ext), packDescription.getPackSource(), ext, packDescription.getFileSize(ext), loadedIdx));
    }

    void emitBlockLoad(BlockBasedFile file, long position, DfsBlock dfsBlock) {
        this.packLoadListeners.forEach(listener -> listener.onBlockLoad(file.getFileName(), blockBasedFile.desc.getPackSource(), blockBasedFile.ext, position, PackLoadListener.DfsBlockData.of(dfsBlock)));
    }

    protected void addPackLoadListener(PackLoadListener listener) {
        this.packLoadListeners.add(listener);
    }

    @Override
    public void close() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack, long offset) {
            this.id = objectId;
            this.pack = pack;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }

    protected static interface PackLoadListener {
        public void onIndexLoad(String var1, DfsObjDatabase.PackSource var2, PackExt var3, long var4, Object var6);

        public void onBlockLoad(String var1, DfsObjDatabase.PackSource var2, PackExt var3, long var4, DfsBlockData var6);

        public static class DfsBlockData {
            private final int identityHash;
            private final int size;

            static DfsBlockData of(DfsBlock src) {
                return new DfsBlockData(src);
            }

            private DfsBlockData(DfsBlock src) {
                this.identityHash = System.identityHashCode(src);
                this.size = src.size();
            }

            public int getIdentityHash() {
                return this.identityHash;
            }

            public int getSize() {
                return this.size;
            }
        }
    }
}

