/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class ExtensionRepoGroupsResult
extends AbstractWritableResult<List<ExtensionRepoGroup>> {
    private final List<ExtensionRepoGroup> bundleGroups;

    public ExtensionRepoGroupsResult(ResultType resultType, List<ExtensionRepoGroup> bundleGroups) {
        super(resultType);
        this.bundleGroups = Objects.requireNonNull(bundleGroups);
        this.bundleGroups.sort(Comparator.comparing(ExtensionRepoGroup::getBucketName).thenComparing(ExtensionRepoGroup::getGroupId));
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        if (this.bundleGroups.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Bucket", 40, 400, false).column("Group", 40, 200, false).build();
        for (int i = 0; i < this.bundleGroups.size(); ++i) {
            ExtensionRepoGroup group = this.bundleGroups.get(i);
            table.addRow(String.valueOf(i + 1), group.getBucketName(), group.getGroupId());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public List<ExtensionRepoGroup> getResult() {
        return this.bundleGroups;
    }
}

