/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.AccessClient;
import org.apache.nifi.toolkit.client.ConnectionClient;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.ControllerServicesClient;
import org.apache.nifi.toolkit.client.CountersClient;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.InputPortClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientConfig;
import org.apache.nifi.toolkit.client.OutputPortClient;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.toolkit.client.ParamProviderClient;
import org.apache.nifi.toolkit.client.PoliciesClient;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.toolkit.client.ProcessorClient;
import org.apache.nifi.toolkit.client.ProvenanceClient;
import org.apache.nifi.toolkit.client.RemoteProcessGroupClient;
import org.apache.nifi.toolkit.client.ReportingTasksClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.SnippetClient;
import org.apache.nifi.toolkit.client.SystemDiagnosticsClient;
import org.apache.nifi.toolkit.client.TenantsClient;
import org.apache.nifi.toolkit.client.VersionsClient;
import org.apache.nifi.toolkit.client.impl.JerseyAccessClient;
import org.apache.nifi.toolkit.client.impl.JerseyConnectionClient;
import org.apache.nifi.toolkit.client.impl.JerseyControllerClient;
import org.apache.nifi.toolkit.client.impl.JerseyControllerServicesClient;
import org.apache.nifi.toolkit.client.impl.JerseyCountersClient;
import org.apache.nifi.toolkit.client.impl.JerseyFlowClient;
import org.apache.nifi.toolkit.client.impl.JerseyInputPortClient;
import org.apache.nifi.toolkit.client.impl.JerseyOutputPortClient;
import org.apache.nifi.toolkit.client.impl.JerseyParamContextClient;
import org.apache.nifi.toolkit.client.impl.JerseyParamProviderClient;
import org.apache.nifi.toolkit.client.impl.JerseyPoliciesClient;
import org.apache.nifi.toolkit.client.impl.JerseyProcessGroupClient;
import org.apache.nifi.toolkit.client.impl.JerseyProcessorClient;
import org.apache.nifi.toolkit.client.impl.JerseyProvenanceClient;
import org.apache.nifi.toolkit.client.impl.JerseyRemoteProcessGroupClient;
import org.apache.nifi.toolkit.client.impl.JerseyReportingTasksClient;
import org.apache.nifi.toolkit.client.impl.JerseySnippetClient;
import org.apache.nifi.toolkit.client.impl.JerseySystemDiagnosticsClient;
import org.apache.nifi.toolkit.client.impl.JerseyTenantsClient;
import org.apache.nifi.toolkit.client.impl.JerseyVersionsClient;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;

public class JerseyNiFiClient
implements NiFiClient {
    static final String NIFI_CONTEXT = "nifi-api";
    static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    static final int DEFAULT_READ_TIMEOUT = 10000;
    public final Client client;
    private final WebTarget baseTarget;

    private JerseyNiFiClient(Builder builder) {
        NiFiClientConfig clientConfig = builder.getConfig();
        if (clientConfig == null) {
            throw new IllegalArgumentException("NiFiClientConfig cannot be null");
        }
        Object baseUrl = clientConfig.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("Base URL cannot be blank");
        }
        if (((String)baseUrl).endsWith("/")) {
            baseUrl = ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1);
        }
        if (!((String)baseUrl).endsWith(NIFI_CONTEXT)) {
            baseUrl = (String)baseUrl + "/nifi-api";
        }
        try {
            new URI((String)baseUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid base URL: " + e.getMessage(), e);
        }
        SSLContext sslContext = clientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = clientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        int connectTimeout = clientConfig.getConnectTimeout() == null ? 10000 : clientConfig.getConnectTimeout();
        int readTimeout = clientConfig.getReadTimeout() == null ? 10000 : clientConfig.getReadTimeout();
        ClientConfig jerseyClientConfig = new ClientConfig();
        jerseyClientConfig.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        jerseyClientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
        jerseyClientConfig.register((Object)JerseyNiFiClient.jacksonJaxbJsonProvider());
        clientBuilder.withConfig((Configuration)jerseyClientConfig);
        this.client = clientBuilder.build();
        this.baseTarget = this.client.target((String)baseUrl);
    }

    @Override
    public ControllerClient getControllerClient() {
        return new JerseyControllerClient(this.baseTarget);
    }

    @Override
    public ControllerClient getControllerClient(RequestConfig requestConfig) {
        return new JerseyControllerClient(this.baseTarget, requestConfig);
    }

    @Override
    public ControllerServicesClient getControllerServicesClient() {
        return new JerseyControllerServicesClient(this.baseTarget);
    }

    @Override
    public ControllerServicesClient getControllerServicesClient(RequestConfig requestConfig) {
        return new JerseyControllerServicesClient(this.baseTarget, requestConfig);
    }

    @Override
    public FlowClient getFlowClient() {
        return new JerseyFlowClient(this.baseTarget);
    }

    @Override
    public FlowClient getFlowClient(RequestConfig requestConfig) {
        return new JerseyFlowClient(this.baseTarget, requestConfig);
    }

    @Override
    public ProcessGroupClient getProcessGroupClient() {
        return new JerseyProcessGroupClient(this.baseTarget);
    }

    @Override
    public ProcessGroupClient getProcessGroupClient(RequestConfig requestConfig) {
        return new JerseyProcessGroupClient(this.baseTarget, requestConfig);
    }

    @Override
    public ProcessorClient getProcessorClient() {
        return new JerseyProcessorClient(this.baseTarget);
    }

    @Override
    public ProcessorClient getProcessorClient(RequestConfig requestConfig) {
        return new JerseyProcessorClient(this.baseTarget, requestConfig);
    }

    @Override
    public VersionsClient getVersionsClient() {
        return new JerseyVersionsClient(this.baseTarget);
    }

    @Override
    public VersionsClient getVersionsClient(RequestConfig requestConfig) {
        return new JerseyVersionsClient(this.baseTarget, requestConfig);
    }

    @Override
    public TenantsClient getTenantsClient() {
        return new JerseyTenantsClient(this.baseTarget);
    }

    @Override
    public TenantsClient getTenantsClient(RequestConfig requestConfig) {
        return new JerseyTenantsClient(this.baseTarget, requestConfig);
    }

    @Override
    public PoliciesClient getPoliciesClient() {
        return new JerseyPoliciesClient(this.baseTarget);
    }

    @Override
    public PoliciesClient getPoliciesClient(RequestConfig requestConfig) {
        return new JerseyPoliciesClient(this.baseTarget, requestConfig);
    }

    @Override
    public ReportingTasksClient getReportingTasksClient() {
        return new JerseyReportingTasksClient(this.baseTarget);
    }

    @Override
    public ReportingTasksClient getReportingTasksClient(RequestConfig requestConfig) {
        return new JerseyReportingTasksClient(this.baseTarget, requestConfig);
    }

    @Override
    public ParamProviderClient getParamProviderClient() {
        return new JerseyParamProviderClient(this.baseTarget);
    }

    @Override
    public ParamProviderClient getParamProviderClient(RequestConfig requestConfig) {
        return new JerseyParamProviderClient(this.baseTarget, requestConfig);
    }

    @Override
    public ParamContextClient getParamContextClient() {
        return new JerseyParamContextClient(this.baseTarget);
    }

    @Override
    public ParamContextClient getParamContextClient(RequestConfig requestConfig) {
        return new JerseyParamContextClient(this.baseTarget, requestConfig);
    }

    @Override
    public CountersClient getCountersClient() {
        return new JerseyCountersClient(this.baseTarget);
    }

    @Override
    public CountersClient getCountersClient(RequestConfig requestConfig) {
        return new JerseyCountersClient(this.baseTarget, requestConfig);
    }

    @Override
    public ConnectionClient getConnectionClient() {
        return new JerseyConnectionClient(this.baseTarget);
    }

    @Override
    public ConnectionClient getConnectionClient(RequestConfig requestConfig) {
        return new JerseyConnectionClient(this.baseTarget, requestConfig);
    }

    @Override
    public RemoteProcessGroupClient getRemoteProcessGroupClient() {
        return new JerseyRemoteProcessGroupClient(this.baseTarget);
    }

    @Override
    public RemoteProcessGroupClient getRemoteProcessGroupClient(RequestConfig requestConfig) {
        return new JerseyRemoteProcessGroupClient(this.baseTarget, requestConfig);
    }

    @Override
    public InputPortClient getInputPortClient() {
        return new JerseyInputPortClient(this.baseTarget);
    }

    @Override
    public InputPortClient getInputPortClient(RequestConfig requestConfig) {
        return new JerseyInputPortClient(this.baseTarget, requestConfig);
    }

    @Override
    public OutputPortClient getOutputPortClient() {
        return new JerseyOutputPortClient(this.baseTarget);
    }

    @Override
    public OutputPortClient getOutputPortClient(RequestConfig requestConfig) {
        return new JerseyOutputPortClient(this.baseTarget, requestConfig);
    }

    @Override
    public ProvenanceClient getProvenanceClient() {
        return new JerseyProvenanceClient(this.baseTarget);
    }

    @Override
    public ProvenanceClient getProvenanceClient(RequestConfig requestConfig) {
        return new JerseyProvenanceClient(this.baseTarget, requestConfig);
    }

    @Override
    public AccessClient getAccessClient() {
        return new JerseyAccessClient(this.baseTarget);
    }

    @Override
    public SnippetClient getSnippetClient() {
        return new JerseySnippetClient(this.baseTarget);
    }

    @Override
    public SnippetClient getSnippetClient(RequestConfig requestConfig) {
        return new JerseySnippetClient(this.baseTarget, requestConfig);
    }

    @Override
    public SystemDiagnosticsClient getSystemsDiagnosticsClient() {
        return new JerseySystemDiagnosticsClient(this.baseTarget);
    }

    @Override
    public SystemDiagnosticsClient getSystemsDiagnosticsClient(RequestConfig requestConfig) {
        return new JerseySystemDiagnosticsClient(this.baseTarget, requestConfig);
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JacksonJaxbJsonProvider jacksonJaxbJsonProvider() {
        JacksonJaxbJsonProvider jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(mapper.getTypeFactory()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jacksonJaxbJsonProvider.setMapper(mapper);
        return jacksonJaxbJsonProvider;
    }

    public static class Builder
    implements NiFiClient.Builder {
        private NiFiClientConfig clientConfig;

        @Override
        public Builder config(NiFiClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @Override
        public NiFiClientConfig getConfig() {
            return this.clientConfig;
        }

        @Override
        public NiFiClient build() {
            return new JerseyNiFiClient(this);
        }
    }
}

