/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class IfElseEvaluator
extends StringEvaluator {
    private final Evaluator<Boolean> subject;
    private final Evaluator<String> trueEvaluator;
    private final Evaluator<String> falseEvaluator;

    public IfElseEvaluator(Evaluator<Boolean> subject, Evaluator<String> trueEvaluator, Evaluator<String> falseEvaluator) {
        this.subject = subject;
        this.trueEvaluator = trueEvaluator;
        this.falseEvaluator = falseEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        QueryResult<Boolean> subjectValue = this.subject.evaluate(evaluationContext);
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String ifElseValue = Boolean.TRUE.equals(subjectValue.getValue()) ? this.trueEvaluator.evaluate(evaluationContext).getValue() : this.falseEvaluator.evaluate(evaluationContext).getValue();
        return new StringQueryResult(ifElseValue);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

