/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class AndEvaluator
extends BooleanEvaluator {
    private final Evaluator<Boolean> subjectEvaluator;
    private final Evaluator<Boolean> rhsEvaluator;

    public AndEvaluator(Evaluator<Boolean> subjectEvaluator, Evaluator<Boolean> rhsEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
        this.rhsEvaluator = rhsEvaluator;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        QueryResult<Boolean> subjectValue = this.subjectEvaluator.evaluate(evaluationContext);
        if (subjectValue == null) {
            return new BooleanQueryResult(null);
        }
        if (Boolean.FALSE.equals(subjectValue.getValue())) {
            return new BooleanQueryResult(false);
        }
        BooleanQueryResult rhsResult = evaluationContext.getEvaluatorState().getState(this, BooleanQueryResult.class);
        if (rhsResult != null) {
            return rhsResult;
        }
        QueryResult<Boolean> rhsValue = this.rhsEvaluator.evaluate(evaluationContext);
        BooleanQueryResult result = rhsValue == null ? new BooleanQueryResult(false) : new BooleanQueryResult(rhsValue.getValue());
        evaluationContext.getEvaluatorState().putState(this, result);
        return result;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

