/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.annotation.EdmConstantExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmExpression;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmConstantExpressionImpl
extends AbstractEdmExpression
implements EdmConstantExpression {
    private EdmPrimitiveType type;
    private final CsdlConstantExpression csdlExp;
    private boolean built = false;
    private Object primitive;
    private String enumTypeName;
    private List<String> enumMembers;
    private Geospatial geospatial;

    public EdmConstantExpressionImpl(Edm edm, CsdlConstantExpression constExprConstruct) {
        super(edm, constExprConstruct.getType().toString());
        this.csdlExp = constExprConstruct;
    }

    @Override
    public String getValueAsString() {
        return this.csdlExp.getValue();
    }

    private void build() {
        if (this.csdlExp.getType() == CsdlConstantExpression.ConstantExpressionType.EnumMember) {
            if (this.csdlExp.getValue() == null) {
                throw new EdmException("Expression value must not be null");
            }
            ArrayList<String> localEnumValues = new ArrayList<String>();
            for (String split : this.csdlExp.getValue().split(" ")) {
                String[] enumSplit = split.split("/");
                if (enumSplit.length != 2) {
                    throw new EdmException("Enum expression value must consist of enumTypeName/EnumMember.");
                }
                this.enumTypeName = enumSplit[0];
                localEnumValues.add(enumSplit[1]);
            }
            this.enumMembers = Collections.unmodifiableList(localEnumValues);
        } else {
            EdmPrimitiveTypeKind kind;
            switch (this.csdlExp.getType()) {
                case Binary: {
                    kind = EdmPrimitiveTypeKind.Binary;
                    break;
                }
                case Bool: {
                    kind = EdmPrimitiveTypeKind.Boolean;
                    break;
                }
                case Date: {
                    kind = EdmPrimitiveTypeKind.Date;
                    break;
                }
                case DateTimeOffset: {
                    kind = EdmPrimitiveTypeKind.DateTimeOffset;
                    break;
                }
                case Decimal: {
                    kind = EdmPrimitiveTypeKind.Decimal;
                    break;
                }
                case Duration: {
                    kind = EdmPrimitiveTypeKind.Duration;
                    break;
                }
                case Float: {
                    kind = EdmPrimitiveTypeKind.Single;
                    break;
                }
                case Guid: {
                    kind = EdmPrimitiveTypeKind.Guid;
                    break;
                }
                case Int: {
                    kind = EdmPrimitiveTypeKind.Int32;
                    break;
                }
                case TimeOfDay: {
                    kind = EdmPrimitiveTypeKind.TimeOfDay;
                    break;
                }
                default: {
                    kind = EdmPrimitiveTypeKind.String;
                }
            }
            this.type = EdmPrimitiveTypeFactory.getInstance(kind);
            try {
                this.primitive = this.type.valueOfString(this.csdlExp.getValue(), null, null, null, null, null, this.type.getDefaultType());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.built = true;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        switch (this.csdlExp.getType()) {
            case Binary: {
                return EdmExpression.EdmExpressionType.Binary;
            }
            case Bool: {
                return EdmExpression.EdmExpressionType.Bool;
            }
            case Date: {
                return EdmExpression.EdmExpressionType.Date;
            }
            case DateTimeOffset: {
                return EdmExpression.EdmExpressionType.DateTimeOffset;
            }
            case Decimal: {
                return EdmExpression.EdmExpressionType.Decimal;
            }
            case Duration: {
                return EdmExpression.EdmExpressionType.Duration;
            }
            case EnumMember: {
                return EdmExpression.EdmExpressionType.EnumMember;
            }
            case Float: {
                return EdmExpression.EdmExpressionType.Float;
            }
            case Guid: {
                return EdmExpression.EdmExpressionType.Guid;
            }
            case Int: {
                return EdmExpression.EdmExpressionType.Int;
            }
            case String: {
                return EdmExpression.EdmExpressionType.String;
            }
            case TimeOfDay: {
                return EdmExpression.EdmExpressionType.TimeOfDay;
            }
        }
        throw new EdmException("Invalid Expressiontype for constant expression: " + (Object)((Object)this.csdlExp.getType()));
    }

    @Override
    public Object asPrimitive() {
        if (!this.built) {
            this.build();
        }
        return this.primitive;
    }

    @Override
    public List<String> asEnumMembers() {
        if (!this.built) {
            this.build();
        }
        return this.enumMembers;
    }

    @Override
    public String getEnumTypeName() {
        if (!this.built) {
            this.build();
        }
        return this.enumTypeName;
    }

    @Override
    public Geospatial asGeospatial() {
        if (!this.built) {
            this.build();
        }
        return this.geospatial;
    }
}

