/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.heartbeat;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.ProducerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class HeartbeatData
extends RemotingSerializable {
    private String clientID;
    private Set<ProducerData> producerDataSet = new HashSet<ProducerData>();
    private Set<ConsumerData> consumerDataSet = new HashSet<ConsumerData>();
    private int heartbeatFingerprint = 0;
    private boolean isWithoutSub = false;

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public Set<ProducerData> getProducerDataSet() {
        return this.producerDataSet;
    }

    public void setProducerDataSet(Set<ProducerData> producerDataSet) {
        this.producerDataSet = producerDataSet;
    }

    public Set<ConsumerData> getConsumerDataSet() {
        return this.consumerDataSet;
    }

    public void setConsumerDataSet(Set<ConsumerData> consumerDataSet) {
        this.consumerDataSet = consumerDataSet;
    }

    public int getHeartbeatFingerprint() {
        return this.heartbeatFingerprint;
    }

    public void setHeartbeatFingerprint(int heartbeatFingerprint) {
        this.heartbeatFingerprint = heartbeatFingerprint;
    }

    public boolean isWithoutSub() {
        return this.isWithoutSub;
    }

    public void setWithoutSub(boolean withoutSub) {
        this.isWithoutSub = withoutSub;
    }

    public String toString() {
        return "HeartbeatData [clientID=" + this.clientID + ", producerDataSet=" + this.producerDataSet + ", consumerDataSet=" + this.consumerDataSet + "]";
    }

    public int computeHeartbeatFingerprint() {
        HeartbeatData heartbeatDataCopy = (HeartbeatData)JSON.parseObject((String)JSON.toJSONString((Object)this), HeartbeatData.class);
        for (ConsumerData consumerData : heartbeatDataCopy.getConsumerDataSet()) {
            for (SubscriptionData subscriptionData : consumerData.getSubscriptionDataSet()) {
                subscriptionData.setSubVersion(0L);
            }
        }
        heartbeatDataCopy.setWithoutSub(false);
        heartbeatDataCopy.setHeartbeatFingerprint(0);
        heartbeatDataCopy.setClientID("");
        return JSON.toJSONString((Object)heartbeatDataCopy).hashCode();
    }
}

