/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit;

import java.util.Map;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SlingContextBuilder {
    @NotNull
    private final ContextPlugins plugins = new ContextPlugins();
    private ResourceResolverType resourceResolverType;
    private Map<String, Object> resourceResolverFactoryActivatorProps;
    private boolean registerSlingModelsFromClassPath = true;

    public SlingContextBuilder() {
    }

    public SlingContextBuilder(@NotNull ResourceResolverType resourceResolverType) {
        this.resourceResolverType(resourceResolverType);
    }

    @NotNull
    public SlingContextBuilder resourceResolverType(@NotNull ResourceResolverType resourceResolverType) {
        this.resourceResolverType = resourceResolverType;
        return this;
    }

    @SafeVarargs
    @NotNull
    public final SlingContextBuilder plugin(ContextPlugin<? extends OsgiContextImpl> ... plugin) {
        this.plugins.addPlugin(plugin);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final SlingContextBuilder beforeSetUp(ContextCallback<? extends OsgiContextImpl> ... beforeSetUpCallback) {
        this.plugins.addBeforeSetUpCallback(beforeSetUpCallback);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final SlingContextBuilder afterSetUp(ContextCallback<? extends OsgiContextImpl> ... afterSetUpCallback) {
        this.plugins.addAfterSetUpCallback(afterSetUpCallback);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final SlingContextBuilder beforeTearDown(ContextCallback<? extends OsgiContextImpl> ... beforeTearDownCallback) {
        this.plugins.addBeforeTearDownCallback(beforeTearDownCallback);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final SlingContextBuilder afterTearDown(ContextCallback<? extends OsgiContextImpl> ... afterTearDownCallback) {
        this.plugins.addAfterTearDownCallback(afterTearDownCallback);
        return this;
    }

    @NotNull
    public SlingContextBuilder resourceResolverFactoryActivatorProps(@NotNull Map<String, Object> props) {
        this.resourceResolverFactoryActivatorProps = props;
        return this;
    }

    @NotNull
    public SlingContextBuilder registerSlingModelsFromClassPath(boolean registerSlingModelsFromClassPath) {
        this.registerSlingModelsFromClassPath = registerSlingModelsFromClassPath;
        return this;
    }

    @NotNull
    public SlingContext build() {
        return new SlingContext(this.plugins, this.resourceResolverFactoryActivatorProps, this.resourceResolverType, this.registerSlingModelsFromClassPath);
    }
}

