/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.console.commons;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

public class IdMExternalResourceProvider implements ExternalResourceProvider {

    private static final long serialVersionUID = 6335503820405008093L;

    private final ResourceRestClient resourceRestClient;

    public IdMExternalResourceProvider(final ResourceRestClient resourceRestClient) {
        this.resourceRestClient = resourceRestClient;
    }

    @Override
    public List<String> get(final String anyType) {
        return resourceRestClient.list().stream().
                filter(r -> anyType == null
                || AnyTypeKind.GROUP.name().equals(anyType)
                || r.getProvision(anyType).isPresent()).
                map(ResourceTO::getKey).
                collect(Collectors.toList());
    }

    @Override
    public List<String> getForRealms() {
        return resourceRestClient.list().stream().
                filter(r -> r.getOrgUnit() != null).
                map(ResourceTO::getKey).
                collect(Collectors.toList());
    }
}
