/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class Tool {
    private static final Log log = LogFactory.getLog(Tool.class);
    private static boolean ant = false;
    private static final String catalinaHome = System.getProperty("catalina.home");
    private static boolean common = false;
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] args) {
        if (catalinaHome == null) {
            log.error("Must set 'catalina.home' system property");
            System.exit(1);
        }
        int index = 0;
        block20: while (true) {
            if (index == args.length) {
                Tool.usage();
                System.exit(1);
            }
            switch (args[index]) {
                case "-ant": {
                    ant = true;
                    break;
                }
                case "-common": {
                    common = true;
                    break;
                }
                case "-server": {
                    server = true;
                    break;
                }
                case "-shared": {
                    shared = true;
                    break;
                }
                default: {
                    break block20;
                }
            }
            ++index;
        }
        if (ant) {
            System.setProperty("ant.home", catalinaHome);
        }
        ClassLoader classLoader = null;
        try {
            ArrayList<File> packed = new ArrayList<File>();
            ArrayList<File> unpacked = new ArrayList<File>();
            unpacked.add(new File(catalinaHome, "classes"));
            packed.add(new File(catalinaHome, "lib"));
            if (common) {
                unpacked.add(new File(catalinaHome, "common" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "common" + File.separator + "lib"));
            }
            if (server) {
                unpacked.add(new File(catalinaHome, "server" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                unpacked.add(new File(catalinaHome, "shared" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(unpacked.toArray(new File[0]), packed.toArray(new File[0]), null);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Class loader creation threw exception", t);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> clazz = null;
        String className = args[index++];
        try {
            if (log.isDebugEnabled()) {
                log.debug("Loading application class " + className);
            }
            clazz = classLoader.loadClass(className);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Exception creating instance of " + className, t);
            System.exit(1);
        }
        Method method = null;
        String[] params = new String[args.length - index];
        System.arraycopy(args, index, params, 0, params.length);
        try {
            if (log.isTraceEnabled()) {
                log.trace("Identifying main() method");
            }
            String methodName = "main";
            Class[] paramTypes = new Class[]{params.getClass()};
            method = clazz.getMethod(methodName, paramTypes);
        }
        catch (Throwable t) {
            Bootstrap.handleThrowable(t);
            log.error("Exception locating main() method", t);
            System.exit(1);
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("Calling main() method");
            }
            Object[] paramValues = new Object[]{params};
            method.invoke(null, paramValues);
        }
        catch (Throwable t) {
            Throwable throwable = Bootstrap.unwrapInvocationTargetException(t);
            Bootstrap.handleThrowable(throwable);
            log.error("Exception calling main() method", throwable);
            System.exit(1);
        }
    }

    private static void usage() {
        log.info("Usage:  java org.apache.catalina.startup.Tool [<options>] <class> [<arguments>]");
    }
}

