/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public class JsonObjectGenerator
implements JsonGenerator {
    private final JsonBuilderFactory factory;
    private final LinkedList<Object> builders = new LinkedList();
    private JsonObjectBuilder objectBuilder;
    private JsonArrayBuilder arrayBuilder;

    public JsonObjectGenerator(JsonBuilderFactory factory) {
        this.factory = factory;
    }

    public JsonGenerator writeStartObject() {
        this.objectBuilder = this.factory.createObjectBuilder();
        this.builders.add(this.objectBuilder);
        this.arrayBuilder = null;
        return this;
    }

    public JsonGenerator writeStartObject(String name) {
        this.objectBuilder = this.factory.createObjectBuilder();
        this.builders.add(new NamedBuilder<JsonObjectBuilder>(this.objectBuilder, name));
        this.arrayBuilder = null;
        return this;
    }

    public JsonGenerator writeStartArray() {
        this.arrayBuilder = this.factory.createArrayBuilder();
        this.builders.add(this.arrayBuilder);
        this.objectBuilder = null;
        return this;
    }

    public JsonGenerator writeStartArray(String name) {
        this.arrayBuilder = this.factory.createArrayBuilder();
        this.builders.add(new NamedBuilder<JsonArrayBuilder>(this.arrayBuilder, name));
        this.objectBuilder = null;
        return this;
    }

    public JsonGenerator writeKey(String name) {
        throw new UnsupportedOperationException();
    }

    public JsonGenerator write(String name, JsonValue value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, String value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, BigInteger value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, BigDecimal value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, int value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, long value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, double value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator write(String name, boolean value) {
        this.objectBuilder.add(name, value);
        return this;
    }

    public JsonGenerator writeNull(String name) {
        this.objectBuilder.addNull(name);
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(String value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(int value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(long value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(double value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(boolean value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator writeNull() {
        this.arrayBuilder.addNull();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonGenerator writeEnd() {
        String name;
        NamedBuilder namedBuilder;
        if (this.builders.size() == 1) {
            return this;
        }
        Object last = this.builders.removeLast();
        Object previous = this.builders.getLast();
        if (NamedBuilder.class.isInstance(previous)) {
            namedBuilder = (NamedBuilder)NamedBuilder.class.cast(previous);
            name = namedBuilder.name;
            previous = namedBuilder.builder;
        } else {
            name = null;
        }
        if (JsonArrayBuilder.class.isInstance(last)) {
            JsonArrayBuilder array = (JsonArrayBuilder)JsonArrayBuilder.class.cast(last);
            if (JsonArrayBuilder.class.isInstance(previous)) {
                this.arrayBuilder = (JsonArrayBuilder)JsonArrayBuilder.class.cast(previous);
                this.objectBuilder = null;
                this.arrayBuilder.add(array);
                return this;
            } else {
                if (!JsonObjectBuilder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder: " + String.valueOf(previous));
                this.objectBuilder = (JsonObjectBuilder)JsonObjectBuilder.class.cast(previous);
                this.arrayBuilder = null;
                this.objectBuilder.add(name, array);
            }
            return this;
        } else if (JsonObjectBuilder.class.isInstance(last)) {
            JsonObjectBuilder object = (JsonObjectBuilder)JsonObjectBuilder.class.cast(last);
            if (JsonArrayBuilder.class.isInstance(previous)) {
                this.arrayBuilder = (JsonArrayBuilder)JsonArrayBuilder.class.cast(previous);
                this.objectBuilder = null;
                this.arrayBuilder.add(object);
                return this;
            } else {
                if (!JsonObjectBuilder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder: " + String.valueOf(previous));
                this.objectBuilder = (JsonObjectBuilder)JsonObjectBuilder.class.cast(previous);
                this.arrayBuilder = null;
                this.objectBuilder.add(name, object);
            }
            return this;
        } else {
            if (!NamedBuilder.class.isInstance(last)) throw new IllegalArgumentException("Unsupported previous builder: " + String.valueOf(previous));
            namedBuilder = (NamedBuilder)NamedBuilder.class.cast(last);
            if (!JsonObjectBuilder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder, expected object builder: " + String.valueOf(previous));
            this.objectBuilder = (JsonObjectBuilder)JsonObjectBuilder.class.cast(previous);
            if (JsonArrayBuilder.class.isInstance(namedBuilder.builder)) {
                this.objectBuilder.add(namedBuilder.name, (JsonArrayBuilder)JsonArrayBuilder.class.cast(namedBuilder.builder));
                this.arrayBuilder = null;
                return this;
            } else {
                if (!JsonObjectBuilder.class.isInstance(namedBuilder.builder)) throw new IllegalArgumentException("Unsupported previous builder: " + String.valueOf(previous));
                this.objectBuilder.add(namedBuilder.name, (JsonObjectBuilder)JsonObjectBuilder.class.cast(namedBuilder.builder));
                this.arrayBuilder = null;
            }
        }
        return this;
    }

    public void flush() {
    }

    public void close() {
        this.flush();
    }

    public JsonValue getResult() {
        Object last = this.builders.getLast();
        if (JsonArrayBuilder.class.isInstance(last)) {
            return ((JsonArrayBuilder)JsonArrayBuilder.class.cast(last)).build();
        }
        if (JsonObjectBuilder.class.isInstance(last)) {
            return ((JsonObjectBuilder)JsonObjectBuilder.class.cast(last)).build();
        }
        throw new IllegalArgumentException("Nothing prepared or wrongly prepared");
    }

    private static class NamedBuilder<T> {
        private final T builder;
        private final String name;

        private NamedBuilder(T builder, String name) {
            this.builder = builder;
            this.name = name;
        }
    }
}

