/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import java.util.concurrent.BlockingQueue;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.PartitionThreadRootController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.BatchParallelWorkUnit;
import org.apache.batchee.container.util.PartitionsBuilderConfig;

public class BatchPartitionWorkUnit
extends BatchParallelWorkUnit {
    protected final BlockingQueue<BatchPartitionWorkUnit> completedThreadQueue;

    public BatchPartitionWorkUnit(RuntimeJobExecution jobExecution, PartitionsBuilderConfig config, ServicesManager manager) {
        super(jobExecution, true, manager);
        this.completedThreadQueue = config.getCompletedQueue();
        this.controller = new PartitionThreadRootController(jobExecution, config, manager);
    }

    @Override
    protected void markThreadCompleted() {
        if (this.completedThreadQueue != null) {
            this.completedThreadQueue.add(this);
        }
    }

    public void inheritStepContext(StepContextImpl sc) {
        this.controller.setParentStepContext(sc);
    }
}

