/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRuleList;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.rapier.RapierGeneralizationHelper;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRule;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRuleItem;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRulePriorityQueue;

public class Rapier
extends TextRulerBasicLearner {
    public static final String COMPRESSION_FAIL_MAX_COUNT_KEY = "compressionFailMaxCount";
    public static final String RULELIST_SIZE_KEY = "ruleListSize";
    public static final String PAIR_COUNT_KEY = "pairCount";
    public static final String LIM_NO_IMPROVEMENTS_KEY = "limNoImprovements";
    public static final String NOISE_THESHOLD_KEY = "noiseThreshold";
    public static final String POSTAG_ROOTTYPE_KEY = "posTagRootType";
    public static final String MIN_COVERED_POSITIVES_KEY = "minCoveredPositives";
    public static final String USE_ALL_GENSETS_AT_SPECIALIZATION_KEY = "useAllGenSetsAtSpecialization";
    public static final int STANDARD_COMPRESSION_FAIL_MAX_COUNT = 3;
    public static final int STANDARD_RULELIST_SIZE = 50;
    public static final int STANDARD_PAIR_COUNT = 4;
    public static final int STANDARD_LIM_NO_IMPROVEMENTS = 3;
    public static final float STANDARD_NOISE_THREHSOLD = 0.9f;
    public static final String STANDARD_POSTAG_ROOTTYPE = "org.apache.uima.ml.ML.postag";
    public static final int STANDARD_MIN_COVERED_POSITIVES = 1;
    public static final boolean STANDARD_USE_ALL_GENSETS_AT_SPECIALIZATION = true;
    private int compressionFailMaxCount = 3;
    private int ruleListSize = 50;
    private int pairCount = 4;
    private int limNoImprovements = 3;
    private float noiseThreshold = 0.9f;
    private String posTagRootTypeName = "org.apache.uima.ml.ML.postag";
    private int minCoveredPositives = 1;
    private boolean useAllGenSetsAtSpecialization = true;
    private Map<String, TextRulerStatisticsCollector> cachedTestedRuleStatistics = new HashMap<String, TextRulerStatisticsCollector>();
    private int initialRuleBaseSize;
    private List<TextRulerExample> examples;
    private TextRulerRuleList slotRules;
    private RapierRulePriorityQueue ruleList;
    private String currentSlotName;

    public Rapier(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTMFile, tmpDir, slotNames, filterSet, skip, delegate);
    }

    @Override
    protected void doRun() {
        for (int i = 0; i < this.slotNames.length; ++i) {
            int compressionFailCount = 0;
            this.currentSlotName = this.slotNames[i];
            this.cachedTestedRuleStatistics.clear();
            this.exampleDocuments.createExamplesForTarget(new TextRulerTarget(this.currentSlotName, (TextRulerBasicLearner)this));
            this.examples = this.exampleDocuments.getAllPositiveExamples();
            if (this.shouldAbort()) {
                return;
            }
            this.slotRules = new TextRulerRuleList();
            this.ruleList = new RapierRulePriorityQueue(this.ruleListSize);
            TextRulerToolkit.log("--- RAPIER START for Slot " + this.currentSlotName);
            this.sendStatusUpdateToDelegate("Creating initial rule base...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
            this.fillSlotRulesWithMostSpecificRules();
            this.updateCompressionStatusString();
            while (compressionFailCount < this.compressionFailMaxCount) {
                TextRulerToolkit.log("***** NEW COMPRESSION ROUND; FailCount = " + compressionFailCount);
                if (this.shouldAbort()) {
                    return;
                }
                RapierRule bestRule = this.findNewRule();
                if (bestRule != null && bestRule.getCoveringStatistics().getCoveredPositivesCount() >= this.minCoveredPositives && bestRule.noiseValue() >= (double)this.noiseThreshold && !this.slotRules.contains(bestRule)) {
                    this.addRuleAndRemoveEmpiricallySubsumedRules(bestRule);
                    continue;
                }
                ++compressionFailCount;
            }
        }
        this.sendStatusUpdateToDelegate("Done", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
        this.cachedTestedRuleStatistics.clear();
        TextRulerToolkit.log("--- RAPIER END");
    }

    private void updateCompressionStatusString() {
        double percent = Math.round((double)this.slotRules.size() / (double)this.initialRuleBaseSize * 100.0);
        this.sendStatusUpdateToDelegate("Compressing... (Rules = " + this.slotRules.size() + "/" + this.initialRuleBaseSize + "  = " + percent + " % ratio)", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
    }

    private void addAvailablePosTagConstraintToItem(RapierRuleItem item, AnnotationFS tokenAnnotation, TextRulerExample example) {
        if (this.posTagRootTypeName != null && this.posTagRootTypeName.length() > 0) {
            AnnotationFS posTag;
            List<AnnotationFS> posTagAnnotations;
            CAS cas = example.getDocumentCAS();
            TypeSystem ts = cas.getTypeSystem();
            Type posTagsRootType = ts.getType(this.posTagRootTypeName);
            if (ts != null && (posTagAnnotations = TextRulerToolkit.getAnnotationsWithinBounds(cas, tokenAnnotation.getBegin(), tokenAnnotation.getEnd(), null, posTagsRootType)).size() > 0 && (posTag = posTagAnnotations.get(0)).getBegin() == tokenAnnotation.getBegin() && posTag.getEnd() == tokenAnnotation.getEnd()) {
                item.addTagConstraint(posTag.getType().getShortName());
            }
        }
    }

    private void fillSlotRulesWithMostSpecificRules() {
        this.slotRules.clear();
        for (TextRulerExample example : this.examples) {
            RapierRuleItem ruleItem;
            RapierRule rule = new RapierRule(this, example.getTarget());
            TextRulerAnnotation slotAnnotation = example.getAnnotation();
            CAS docCas = example.getDocumentCAS();
            TypeSystem ts = docCas.getTypeSystem();
            Type tokensRootType = ts.getType("org.apache.uima.ruta.type.ANY");
            List<AnnotationFS> before = TextRulerToolkit.getAnnotationsBeforePosition(example.getDocumentCAS(), slotAnnotation.getBegin(), -1, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
            List<AnnotationFS> after = TextRulerToolkit.getAnnotationsAfterPosition(example.getDocumentCAS(), slotAnnotation.getEnd(), -1, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
            List<AnnotationFS> inside = TextRulerToolkit.getAnnotationsWithinBounds(example.getDocumentCAS(), slotAnnotation.getBegin(), slotAnnotation.getEnd(), TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
            for (int i = before.size() - 1; i >= 0; --i) {
                AnnotationFS afs = before.get(i);
                ruleItem = new RapierRuleItem();
                ruleItem.addWordConstraint(new TextRulerWordConstraint(new TextRulerAnnotation(afs, example.getDocument())));
                this.addAvailablePosTagConstraintToItem(ruleItem, afs, example);
                rule.addPreFillerItem(ruleItem);
            }
            for (AnnotationFS afs : inside) {
                ruleItem = new RapierRuleItem();
                ruleItem.addWordConstraint(new TextRulerWordConstraint(new TextRulerAnnotation(afs, example.getDocument())));
                this.addAvailablePosTagConstraintToItem(ruleItem, afs, example);
                rule.addFillerItem(ruleItem);
            }
            for (AnnotationFS afs : after) {
                ruleItem = new RapierRuleItem();
                ruleItem.addWordConstraint(new TextRulerWordConstraint(new TextRulerAnnotation(afs, example.getDocument())));
                this.addAvailablePosTagConstraintToItem(ruleItem, afs, example);
                rule.addPostFillerItem(ruleItem);
            }
            TextRulerStatisticsCollector c = new TextRulerStatisticsCollector();
            c.addCoveredPositive(example);
            rule.setCoveringStatistics(c);
            this.slotRules.add(rule);
        }
        this.initialRuleBaseSize = this.slotRules.size();
    }

    protected void addRuleAndRemoveEmpiricallySubsumedRules(RapierRule rule) {
        if (!this.slotRules.contains(rule)) {
            ArrayList<TextRulerRule> rulesToRemove = new ArrayList<TextRulerRule>();
            Set<TextRulerExample> coveredExamples = rule.getCoveringStatistics().getCoveredPositiveExamples();
            for (TextRulerRule r : this.slotRules) {
                if (!coveredExamples.containsAll(r.getCoveringStatistics().getCoveredPositiveExamples())) continue;
                rulesToRemove.add(r);
            }
            for (TextRulerRule removeR : rulesToRemove) {
                this.slotRules.remove(removeR);
            }
            this.slotRules.add(rule);
            this.updateCompressionStatusString();
        }
    }

    protected RapierRule findNewRule() {
        Random rand = new Random(System.currentTimeMillis());
        HashSet<RapierRule> generalizations = new HashSet<RapierRule>();
        this.ruleList.clear();
        if (this.slotRules.size() <= 1) {
            return null;
        }
        ArrayList<RapierRule> uncompressedRules = new ArrayList<RapierRule>();
        for (TextRulerRule r : this.slotRules) {
            if (!((RapierRule)r).isInitialRule()) continue;
            uncompressedRules.add((RapierRule)r);
        }
        int pairsLeft = this.pairCount;
        if (uncompressedRules.size() == 1) {
            rule1 = (RapierRule)uncompressedRules.get(0);
            RapierRule rule2 = null;
            while (rule2 == null || rule1 == rule2) {
                rule2 = (RapierRule)this.slotRules.get(rand.nextInt(this.slotRules.size()));
            }
            generalizations.addAll(this.getFillerGeneralizationsForRulePair(rule1, rule2));
            if (this.shouldAbort()) {
                return null;
            }
            --pairsLeft;
        } else if (uncompressedRules.size() == 2) {
            rule1 = (RapierRule)uncompressedRules.get(0);
            RapierRule rule2 = (RapierRule)uncompressedRules.get(1);
            generalizations.addAll(this.getFillerGeneralizationsForRulePair(rule1, rule2));
            if (this.shouldAbort()) {
                return null;
            }
            --pairsLeft;
        } else if (uncompressedRules.size() > 2) {
            int uPairCount = this.pairCount;
            if (uPairCount > uncompressedRules.size()) {
                uPairCount /= 2;
            }
            for (int i = 0; i < uPairCount; ++i) {
                RapierRule rule1 = (RapierRule)uncompressedRules.get(rand.nextInt(uncompressedRules.size()));
                RapierRule rule2 = null;
                while (rule2 == null || rule1 == rule2) {
                    rule2 = (RapierRule)uncompressedRules.get(rand.nextInt(uncompressedRules.size()));
                }
                generalizations.addAll(this.getFillerGeneralizationsForRulePair(rule1, rule2));
                --pairsLeft;
            }
        }
        for (int i = 0; i < pairsLeft; ++i) {
            RapierRule rule1 = (RapierRule)this.slotRules.get(rand.nextInt(this.slotRules.size()));
            RapierRule rule2 = null;
            while (rule2 == null || rule1 == rule2) {
                rule2 = (RapierRule)this.slotRules.get(rand.nextInt(this.slotRules.size()));
            }
            generalizations.addAll(this.getFillerGeneralizationsForRulePair(rule1, rule2));
            if (!this.shouldAbort()) continue;
            return null;
        }
        ArrayList<RapierRule> testRules = new ArrayList<RapierRule>(generalizations);
        for (RapierRule r : testRules) {
            r.combineSenselessPatternListItems();
        }
        this.testRulesIfNotCached(testRules);
        if (this.shouldAbort()) {
            return null;
        }
        for (RapierRule newRule : generalizations) {
            this.ruleList.add(newRule);
        }
        int n = 0;
        double bestValue = Double.MAX_VALUE;
        int noImprovementCounter = 0;
        while (true) {
            ArrayList<RapierRule> specTestRules;
            TextRulerToolkit.log(" --- NEW SPECIALIZATOIN ROUND; n = " + ++n + "  noImprovementCounter = " + noImprovementCounter);
            ArrayList<RapierRule> newRuleList = new ArrayList<RapierRule>();
            for (RapierRule curRule : this.ruleList) {
                specTestRules = new ArrayList<RapierRule>(this.specializePreFiller(curRule, n));
                for (RapierRule r : specTestRules) {
                    r.combineSenselessPatternListItems();
                }
                this.testRulesIfNotCached(specTestRules);
                if (this.shouldAbort()) {
                    return null;
                }
                for (RapierRule r : specTestRules) {
                    newRuleList.add(r);
                }
            }
            this.ruleList.addAll(newRuleList);
            newRuleList.clear();
            for (RapierRule curRule : this.ruleList) {
                specTestRules = new ArrayList<RapierRule>(this.specializePostFiller(curRule, n));
                for (RapierRule r : specTestRules) {
                    r.combineSenselessPatternListItems();
                }
                this.testRulesIfNotCached(specTestRules);
                if (this.shouldAbort()) {
                    return null;
                }
                for (RapierRule r : specTestRules) {
                    newRuleList.add(r);
                }
            }
            this.ruleList.addAll(newRuleList);
            RapierRule bestRule = this.ruleList.peek();
            if (bestRule.producesOnlyValidFillers()) break;
            if (bestRule.getPriority() < bestValue) {
                noImprovementCounter = 0;
                bestValue = bestRule.getPriority();
                continue;
            }
            if (++noImprovementCounter > this.limNoImprovements) break;
        }
        RapierRule bestRule = this.ruleList.peek();
        return bestRule;
    }

    private List<RapierRule> getFillerGeneralizationsForRulePair(RapierRule rule1, RapierRule rule2) {
        TextRulerToolkit.log("------------------------------------------------------------------------------------------");
        TextRulerToolkit.log("getFillerGeneralizationsForRulePair:");
        TextRulerToolkit.log("Rule1: " + rule1.getRuleString());
        TextRulerToolkit.log("Rule2: " + rule2.getRuleString());
        ArrayList<RapierRule> result = new ArrayList<RapierRule>();
        ArrayList<TextRulerRulePattern> genList = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(rule1.getFillerPattern(), rule2.getFillerPattern());
        for (TextRulerRulePattern pattern : genList) {
            RapierRule newRule = new RapierRule(this, rule1.getTarget());
            for (TextRulerRuleItem patternItem : pattern) {
                newRule.addFillerItem(patternItem.copy());
            }
            newRule.setParent1(rule1.copy());
            newRule.setParent1PreFiller_n(0);
            newRule.setParent1PostFiller_n(0);
            newRule.setParent2(rule2.copy());
            newRule.setParent2PreFiller_n(0);
            newRule.setParent2PostFiller_n(0);
            result.add(newRule);
            newRule.setNeedsCompile(true);
        }
        TextRulerToolkit.log("   getGeneralizationsForRulePair result list size = " + result.size());
        return result;
    }

    public List<RapierRule> specializePreFiller(RapierRule curRule, int n) {
        int i;
        RapierRule baseRule1 = curRule.getParent1();
        RapierRule baseRule2 = curRule.getParent2();
        int n1 = curRule.getParent1PreFiller_n();
        int n2 = curRule.getParent2PreFiller_n();
        TextRulerRulePattern preFiller1 = baseRule1.getPreFillerPattern();
        TextRulerRulePattern preFiller2 = baseRule2.getPreFillerPattern();
        int preFiller1MaxIndex = preFiller1.size() - n1 - 1;
        int preFiller2MaxIndex = preFiller2.size() - n2 - 1;
        TextRulerRulePattern consideredPreFiller1 = new TextRulerRulePattern();
        TextRulerRulePattern consideredPreFiller2 = new TextRulerRulePattern();
        for (i = preFiller1.size() - n; i >= 0 && i <= preFiller1MaxIndex; ++i) {
            consideredPreFiller1.add((TextRulerRuleItem)preFiller1.get(i));
        }
        for (i = preFiller2.size() - n + 1; i >= 0 && i <= preFiller2MaxIndex; ++i) {
            consideredPreFiller2.add((TextRulerRuleItem)preFiller2.get(i));
        }
        ArrayList<TextRulerRulePattern> genList1 = null;
        if (consideredPreFiller1.size() + consideredPreFiller2.size() > 0) {
            genList1 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPreFiller1, consideredPreFiller2);
        }
        ArrayList<TextRulerRulePattern> genList2 = null;
        ArrayList<TextRulerRulePattern> genList3 = null;
        if (this.useAllGenSetsAtSpecialization) {
            int i2;
            consideredPreFiller1.clear();
            consideredPreFiller2.clear();
            for (i2 = preFiller1.size() - n + 1; i2 >= 0 && i2 <= preFiller1MaxIndex; ++i2) {
                consideredPreFiller1.add((TextRulerRuleItem)preFiller1.get(i2));
            }
            for (i2 = preFiller2.size() - n; i2 >= 0 && i2 <= preFiller2MaxIndex; ++i2) {
                consideredPreFiller2.add((TextRulerRuleItem)preFiller2.get(i2));
            }
            if (consideredPreFiller1.size() + consideredPreFiller2.size() > 0) {
                genList2 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPreFiller1, consideredPreFiller2);
            }
            consideredPreFiller1.clear();
            consideredPreFiller2.clear();
            for (i2 = preFiller1.size() - n; i2 >= 0 && i2 <= preFiller1MaxIndex; ++i2) {
                consideredPreFiller1.add((TextRulerRuleItem)preFiller1.get(i2));
            }
            for (i2 = preFiller2.size() - n; i2 >= 0 && i2 <= preFiller2MaxIndex; ++i2) {
                consideredPreFiller2.add((TextRulerRuleItem)preFiller2.get(i2));
            }
            if (consideredPreFiller1.size() + consideredPreFiller2.size() > 0) {
                genList3 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPreFiller1, consideredPreFiller2);
            }
        }
        HashSet<TextRulerRulePattern> genSet = new HashSet<TextRulerRulePattern>();
        if (genList1 != null) {
            genSet.addAll(genList1);
        }
        if (genList2 != null) {
            genSet.addAll(genList2);
        }
        if (genList3 != null) {
            genSet.addAll(genList3);
        }
        ArrayList<RapierRule> resultRules = new ArrayList<RapierRule>();
        for (TextRulerRulePattern l : genSet) {
            RapierRule newRule = curRule.copy();
            for (int i3 = l.size() - 1; i3 >= 0; --i3) {
                newRule.addPreFillerItem((TextRulerRuleItem)l.get(i3));
            }
            newRule.setParent1PreFiller_n(n);
            newRule.setParent2PreFiller_n(n);
            resultRules.add(newRule);
        }
        return resultRules;
    }

    public List<RapierRule> specializePostFiller(RapierRule curRule, int n) {
        int i;
        int i2;
        int i3;
        if (n == 0) {
            TextRulerToolkit.log("ERROR ! N SHOULD NOT BE 0!");
        }
        RapierRule baseRule1 = curRule.getParent1();
        RapierRule baseRule2 = curRule.getParent2();
        int n1 = curRule.getParent1PostFiller_n();
        int n2 = curRule.getParent2PostFiller_n();
        TextRulerRulePattern postFiller1 = baseRule1.getPostFillerPattern();
        TextRulerRulePattern postFiller2 = baseRule2.getPostFillerPattern();
        int postFiller1MinIndex = n1;
        int postFiller2MinIndex = n2;
        TextRulerRulePattern consideredPostFiller1 = new TextRulerRulePattern();
        TextRulerRulePattern consideredPostFiller2 = new TextRulerRulePattern();
        for (i3 = postFiller1MinIndex; i3 < postFiller1.size() && i3 < n; ++i3) {
            consideredPostFiller1.add((TextRulerRuleItem)postFiller1.get(i3));
        }
        for (i3 = postFiller2MinIndex; i3 < postFiller2.size() && i3 < n - 1; ++i3) {
            consideredPostFiller2.add((TextRulerRuleItem)postFiller2.get(i3));
        }
        ArrayList<TextRulerRulePattern> genList1 = null;
        if (consideredPostFiller1.size() + consideredPostFiller2.size() > 0) {
            genList1 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPostFiller1, consideredPostFiller2);
        }
        consideredPostFiller1.clear();
        consideredPostFiller2.clear();
        for (i2 = postFiller1MinIndex; i2 < postFiller1.size() && i2 < n - 1; ++i2) {
            consideredPostFiller1.add((TextRulerRuleItem)postFiller1.get(i2));
        }
        for (i2 = postFiller2MinIndex; i2 < postFiller2.size() && i2 < n; ++i2) {
            consideredPostFiller2.add((TextRulerRuleItem)postFiller2.get(i2));
        }
        ArrayList<TextRulerRulePattern> genList2 = null;
        if (consideredPostFiller1.size() + consideredPostFiller2.size() > 0) {
            genList2 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPostFiller1, consideredPostFiller2);
        }
        consideredPostFiller1.clear();
        consideredPostFiller2.clear();
        for (i = postFiller1MinIndex; i < postFiller1.size() && i < n; ++i) {
            consideredPostFiller1.add((TextRulerRuleItem)postFiller1.get(i));
        }
        for (i = postFiller2MinIndex; i < postFiller2.size() && i < n; ++i) {
            consideredPostFiller2.add((TextRulerRuleItem)postFiller2.get(i));
        }
        ArrayList<TextRulerRulePattern> genList3 = null;
        if (consideredPostFiller1.size() + consideredPostFiller2.size() > 0) {
            genList3 = RapierGeneralizationHelper.getGeneralizationsForRuleItemPatterns(consideredPostFiller1, consideredPostFiller2);
        }
        HashSet<TextRulerRulePattern> genSet = new HashSet<TextRulerRulePattern>();
        if (genList1 != null) {
            genSet.addAll(genList1);
        }
        if (genList2 != null) {
            genSet.addAll(genList2);
        }
        if (genList3 != null) {
            genSet.addAll(genList3);
        }
        ArrayList<RapierRule> resultRules = new ArrayList<RapierRule>();
        for (TextRulerRulePattern l : genSet) {
            RapierRule newRule = curRule.copy();
            for (TextRulerRuleItem t : l) {
                newRule.addPostFillerItem(t);
            }
            newRule.setParent1PostFiller_n(n);
            newRule.setParent2PostFiller_n(n);
            resultRules.add(newRule);
        }
        return resultRules;
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return false;
    }

    @Override
    public String getResultString() {
        if (this.slotRules != null) {
            return this.slotRules.getTMFileString(this.getFileHeaderString(true), 1000);
        }
        return "No results available yet!";
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        if (params.containsKey(COMPRESSION_FAIL_MAX_COUNT_KEY)) {
            this.compressionFailMaxCount = (Integer)params.get(COMPRESSION_FAIL_MAX_COUNT_KEY);
        }
        if (params.containsKey(RULELIST_SIZE_KEY)) {
            this.ruleListSize = (Integer)params.get(RULELIST_SIZE_KEY);
        }
        if (params.containsKey(PAIR_COUNT_KEY)) {
            this.pairCount = (Integer)params.get(PAIR_COUNT_KEY);
        }
        if (params.containsKey(LIM_NO_IMPROVEMENTS_KEY)) {
            this.limNoImprovements = (Integer)params.get(LIM_NO_IMPROVEMENTS_KEY);
        }
        if (params.containsKey(NOISE_THESHOLD_KEY)) {
            this.noiseThreshold = ((Float)params.get(NOISE_THESHOLD_KEY)).floatValue();
        }
        if (params.containsKey(POSTAG_ROOTTYPE_KEY)) {
            this.posTagRootTypeName = (String)params.get(POSTAG_ROOTTYPE_KEY);
        }
        if (params.containsKey(MIN_COVERED_POSITIVES_KEY)) {
            this.minCoveredPositives = (Integer)params.get(MIN_COVERED_POSITIVES_KEY);
        }
        if (params.containsKey(USE_ALL_GENSETS_AT_SPECIALIZATION_KEY)) {
            this.useAllGenSetsAtSpecialization = (Boolean)params.get(USE_ALL_GENSETS_AT_SPECIALIZATION_KEY);
        }
    }

    protected void testRulesIfNotCached(List<RapierRule> rules) {
        String key;
        ArrayList<RapierRule> rulesToTest = new ArrayList<RapierRule>();
        for (RapierRule rapierRule : rules) {
            key = rapierRule.getRuleString();
            if (this.cachedTestedRuleStatistics.containsKey(key)) {
                rapierRule.setCoveringStatistics(this.cachedTestedRuleStatistics.get(key).copy());
                TextRulerToolkit.log("CACHE HIT; size=" + this.cachedTestedRuleStatistics.size());
                continue;
            }
            rulesToTest.add(rapierRule);
        }
        if (rulesToTest.size() > 0) {
            Iterator<String> it;
            this.testRulesOnDocumentSet(rulesToTest, this.exampleDocuments);
            if (this.shouldAbort()) {
                return;
            }
            while (this.cachedTestedRuleStatistics.size() + rulesToTest.size() > 10000 && (it = this.cachedTestedRuleStatistics.keySet().iterator()).hasNext()) {
                String string = this.cachedTestedRuleStatistics.keySet().iterator().next();
                this.cachedTestedRuleStatistics.remove(string);
            }
            for (TextRulerRule textRulerRule : rulesToTest) {
                key = textRulerRule.getRuleString();
                this.cachedTestedRuleStatistics.put(key, textRulerRule.getCoveringStatistics().copy());
            }
        }
    }
}

