/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MockServices {
    private static final Logger LOG = Logger.getLogger(MockServices.class.getName());

    private MockServices() {
    }

    public static void setServices(Class<?> ... classArray) throws IllegalArgumentException {
        Class<?> clazz;
        Object object;
        int n;
        try {
            if (System.getProperty("netbeans.home") != null && System.getProperty("netbeans.user") != null) {
                Class<?> clazz2 = MockServices.forName("org.netbeans.core.startup.MainLookup");
                ServiceClassLoader serviceClassLoader = new ServiceClassLoader(classArray, Thread.currentThread().getContextClassLoader(), false);
                Method method = clazz2.getDeclaredMethod("systemClassLoaderChanged", ClassLoader.class);
                method.setAccessible(true);
                method.invoke(null, serviceClassLoader);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "MainLookup couldn't be notified about the context class loader change", exception);
        }
        ServiceClassLoader serviceClassLoader = new ServiceClassLoader(classArray);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        while (true) {
            int n2;
            if ((n = threadGroup.enumerate((Thread[])(object = new Thread[n2 = threadGroup.activeCount() + 1]), true)) < n2) {
                for (int i = 0; i < n; ++i) {
                    try {
                        object[i].setContextClassLoader(serviceClassLoader);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        LOG.log(Level.FINE, "Cannot set context classloader for " + object[i].getName(), securityException);
                    }
                }
                break;
            }
            LOG.fine("Race condition getting all threads, restarting...");
        }
        LOG.log(Level.FINE, "Set context class loader on {0} threads", n);
        try {
            clazz = Class.forName("org.netbeans.core.startup.MainLookup");
            object = clazz.getDeclaredMethod("systemClassLoaderChanged", ClassLoader.class);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke(null, serviceClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "MainLookup couldn't be notified about the context class loader change", exception);
        }
        try {
            clazz = Class.forName("org.openide.util.Lookup");
            object = clazz.getDeclaredMethod("resetDefaultLookup", new Class[0]);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Could not reset Lookup.getDefault()", exception);
        }
    }

    private static Class<?> forName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(string);
    }

    private static final class ServiceClassLoader
    extends ClassLoader {
        private final Class<?>[] services;

        public ServiceClassLoader(Class<?>[] classArray) {
            this(classArray, MockServices.class.getClassLoader(), true);
        }

        public ServiceClassLoader(Class<?>[] classArray, ClassLoader classLoader, boolean bl) {
            super(classLoader);
            for (Class<?> clazz : classArray) {
                try {
                    Class<?> clazz2;
                    if (bl && !clazz.equals(clazz2 = this.getParent().loadClass(clazz.getName()))) {
                        throw new AssertionError((Object)("Service " + clazz + " isn't " + clazz2));
                    }
                    int n = clazz.getModifiers();
                    if (!Modifier.isPublic(n) || Modifier.isAbstract(n)) {
                        throw new IllegalArgumentException("Class " + clazz.getName() + " must be public");
                    }
                    clazz.getConstructor(new Class[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Class " + clazz.getName() + " has no public no-arg constructor").initCause(noSuchMethodException);
                }
                catch (Exception exception) {
                    throw new AssertionError(exception.toString(), exception);
                }
            }
            this.services = classArray;
        }

        @Override
        public URL getResource(String string) {
            Enumeration<URL> enumeration;
            try {
                enumeration = this.getResources(string);
            }
            catch (IOException iOException) {
                return null;
            }
            return enumeration.hasMoreElements() ? enumeration.nextElement() : null;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if (string.equals("META-INF/services/org.openide.util.Lookup") || string.equals("META-INF/services/org.openide.util.Lookup$Provider")) {
                return Collections.enumeration(Collections.emptySet());
            }
            final Enumeration<URL> enumeration = super.getResources(string);
            String string2 = "META-INF/services/";
            if (string.startsWith(string2)) {
                try {
                    Class<?> clazz = this.loadClass(string.substring(string2.length()));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Class<?> clazz2 : this.services) {
                        boolean bl = clazz.isAssignableFrom(clazz2);
                        if (!bl) continue;
                        arrayList.add(clazz2.getName());
                    }
                    if (!arrayList.isEmpty()) {
                        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));
                        for (String string3 : arrayList) {
                            printWriter.println(string3);
                            printWriter.println("#position=100");
                        }
                        printWriter.close();
                        final URL uRL = new URL("metainfservices", null, 0, clazz.getName(), new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL uRL) throws IOException {
                                return new URLConnection(uRL){

                                    @Override
                                    public void connect() throws IOException {
                                    }

                                    @Override
                                    public InputStream getInputStream() throws IOException {
                                        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                                    }
                                };
                            }
                        });
                        return new Enumeration<URL>(){
                            private boolean parent = false;

                            @Override
                            public boolean hasMoreElements() {
                                return !this.parent || enumeration.hasMoreElements();
                            }

                            @Override
                            public URL nextElement() throws NoSuchElementException {
                                if (this.parent) {
                                    return (URL)enumeration.nextElement();
                                }
                                this.parent = true;
                                return uRL;
                            }
                        };
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return enumeration;
        }
    }
}

