/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.List;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteMasterPicker;
import org.jgroups.util.Util;

public class RandomSiteMasterPicker
implements SiteMasterPicker {
    protected boolean verbose;
    protected Supplier<Address> addr_supplier;

    public boolean verbose() {
        return this.verbose;
    }

    public SiteMasterPicker verbose(boolean b) {
        this.verbose = b;
        return this;
    }

    public SiteMasterPicker addressSupplier(Supplier<Address> s) {
        this.addr_supplier = s;
        return this;
    }

    @Override
    public Address pickSiteMaster(List<Address> site_masters, Address original_sender) {
        Address sm_addr = Util.pickRandomElement(site_masters);
        if (this.verbose) {
            System.out.printf("-- picked local site master %s to forward message to\n", sm_addr);
        }
        return sm_addr;
    }

    @Override
    public Route pickRoute(String site, List<Route> routes, Address original_sender) {
        Route route = Util.pickRandomElement(routes);
        if (this.verbose) {
            System.out.printf("-- %s picked remote site master %s and bridge %s to route message\n", this.addr_supplier != null ? this.addr_supplier.get() + ":" : "", route.siteMaster(), route.bridge().address());
        }
        return route;
    }
}

