/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public class QNameValue
extends QualifiedNameValue {
    public QNameValue(StructuredQName qName, AtomicType typeLabel) {
        super(qName, typeLabel);
    }

    public QNameValue(String prefix, NamespaceUri uri, String localName) {
        this(prefix, uri, localName, BuiltInAtomicType.QNAME);
    }

    public QNameValue(String prefix, NamespaceUri uri, String localName, AtomicType type) {
        super(new StructuredQName(prefix, uri, localName), type);
    }

    public QNameValue(String prefix, NamespaceUri uri, String localName, AtomicType type, boolean check) throws XPathException {
        this(QNameValue.buildStructuredQName(prefix, uri, localName, check), type);
    }

    private static StructuredQName buildStructuredQName(String prefix, NamespaceUri uri, String localName, boolean check) throws XPathException {
        if (check && !NameChecker.isValidNCName(localName)) {
            throw new XPathException("Malformed local name in QName: '" + localName + '\'', "FORG0001");
        }
        String string = prefix = prefix == null ? "" : prefix;
        if (check && uri.isEmpty() && prefix.length() != 0) {
            throw new XPathException("QName has null namespace but non-empty prefix", "FOCA0002");
        }
        return new StructuredQName(prefix, uri, localName);
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new QNameValue(this.qName, typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.QNAME;
    }

    @Override
    public AtomicValue getComponent(AccessorFn.Component part) {
        switch (part) {
            case LOCALNAME: {
                return new StringValue(this.getLocalName(), (AtomicType)BuiltInAtomicType.NCNAME);
            }
            case NAMESPACE: {
                return new AnyURIValue(this.getNamespaceURI().toUnicodeString());
            }
            case PREFIX: {
                String prefix = this.getPrefix();
                if (prefix.isEmpty()) {
                    return null;
                }
                return new StringValue(prefix, (AtomicType)BuiltInAtomicType.NCNAME);
            }
        }
        throw new UnsupportedOperationException("Component of QName must be URI, Local Name, or Prefix");
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof QNameValue && this.qName.equals(((QNameValue)other).qName);
    }

    @Override
    public int hashCode() {
        return this.qName.hashCode();
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return null;
    }
}

