/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.TupleUnion;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummaryFactory;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleExamplesTest {
    private final IntegerSummary.Mode umode = IntegerSummary.Mode.Sum;
    private final IntegerSummary.Mode imode = IntegerSummary.Mode.AlwaysOne;
    private final IntegerSummarySetOperations isso = new IntegerSummarySetOperations(this.umode, this.imode);
    private final IntegerSummaryFactory ufactory = new IntegerSummaryFactory(this.umode);
    private final IntegerSummaryFactory ifactory = new IntegerSummaryFactory(this.imode);
    private final UpdatableThetaSketchBuilder thetaBldr = UpdatableThetaSketch.builder();
    private final UpdatableTupleSketchBuilder<Integer, IntegerSummary> tupleBldr = new UpdatableTupleSketchBuilder((SummaryFactory)this.ufactory);

    @Test
    public void example1() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.isso);
        union.union((TupleSketch)tupleSk);
        union.union((ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        CompactTupleSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("TupleUnion Stateful: tuple, theta: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.isso);
        inter.intersect((TupleSketch)tupleSk);
        inter.intersect((ThetaSketch)thetaSk, (Summary)this.ifactory.newSummary().update(Integer.valueOf(1)));
        CompactTupleSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("TupleIntersection Stateful: tuple, theta: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example2() {
        UpdatableTupleSketch tupleSk1 = this.tupleBldr.build();
        UpdatableTupleSketch tupleSk2 = this.tupleBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk1.update((long)i, (Object)1);
            tupleSk2.update((long)(i + 3), (Object)1);
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.isso);
        CompactTupleSketch ucsk = union.union((TupleSketch)tupleSk1, (TupleSketch)tupleSk2);
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("TupleUnion: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.isso);
        CompactTupleSketch icsk = inter.intersect((TupleSketch)tupleSk1, (TupleSketch)tupleSk2);
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("TupleIntersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example3() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.isso);
        CompactTupleSketch ucsk = union.union((TupleSketch)tupleSk, (ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("TupleUnion: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.isso);
        CompactTupleSketch icsk = inter.intersect((TupleSketch)tupleSk, (ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("TupleIntersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void printlnTest() {
        TupleExamplesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

