/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.jetbrains.annotations.NotNull;

public class InvocationChain
implements FilterChain {
    private final ServletHandler servletHandler;
    private final FilterHandler[] filterHandlers;
    private int index = -1;

    public InvocationChain(@NotNull ServletHandler servletHandler, @NotNull FilterHandler[] filterHandlers) {
        this.filterHandlers = filterHandlers;
        this.servletHandler = servletHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(@NotNull ServletRequest req, @NotNull ServletResponse res) throws IOException, ServletException {
        HttpServletResponse hRes;
        HttpServletRequest hReq;
        boolean callFinish = false;
        if (this.index == -1) {
            hReq = (HttpServletRequest)req;
            hRes = (HttpServletResponse)res;
            if (!this.servletHandler.getContext().handleSecurity(hReq, hRes)) {
                if (!(res.isCommitted() || hRes.getStatus() != 200 && hRes.getStatus() != 0)) {
                    hRes.sendError(403);
                }
                return;
            }
            callFinish = true;
        }
        ++this.index;
        try {
            if (this.index < this.filterHandlers.length) {
                this.filterHandlers[this.index].handle(req, res, this);
            } else {
                this.servletHandler.handle(req, res);
            }
        }
        finally {
            if (callFinish) {
                hReq = (HttpServletRequest)req;
                hRes = (HttpServletResponse)res;
                this.servletHandler.getContext().finishSecurity(hReq, hRes);
            }
        }
    }
}

