/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.core;

import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RaftServerService;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequestProcessor;

public abstract class NodeRequestProcessor<T extends Message>
extends RpcRequestProcessor<T> {
    public NodeRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    protected abstract Message processRequest0(RaftServerService var1, T var2, RpcRequestClosure var3);

    protected abstract String getPeerId(T var1);

    protected abstract String getGroupId(T var1);

    @Override
    public Message processRequest(T request, RpcRequestClosure done) {
        PeerId peer = new PeerId();
        String peerIdStr = this.getPeerId(request);
        if (peer.parse(peerIdStr)) {
            String groupId = this.getGroupId(request);
            Node node = done.getRpcCtx().getNodeManager().get(groupId, peer);
            if (node != null) {
                return this.processRequest0((RaftServerService)((Object)node), request, done);
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.ENOENT, "Peer id not found: %s, group: %s", peerIdStr, groupId);
        }
        return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peerId: %s", peerIdStr);
    }
}

