/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.ArgumentMatcherAction;
import org.mockito.invocation.Invocation;

public class MatcherApplicationStrategy {
    private final Invocation invocation;
    private final List<? extends ArgumentMatcher<?>> matchers;

    private MatcherApplicationStrategy(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        this.invocation = invocation;
        this.matchers = matchers;
    }

    public static MatcherApplicationStrategy getMatcherApplicationStrategyFor(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        return new MatcherApplicationStrategy(invocation, matchers);
    }

    public boolean forEachMatcherAndArgument(ArgumentMatcherAction action) {
        boolean isVararg;
        boolean isJavaVarargs = this.invocation.getMethod().isVarArgs() && this.lastMatcherType().map(matcherType -> this.lastParameterType().isAssignableFrom((Class<?>)matcherType)).orElse(false) != false;
        boolean isScalaVararg = this.invocation.getRawArguments().length != this.invocation.getArguments().length && this.optionalClass("scala.collection.Seq").map(seqClass -> Arrays.stream(this.invocation.getMethod().getParameterTypes()).anyMatch(seqClass::isAssignableFrom)).orElse(false) != false;
        boolean bl = isVararg = isJavaVarargs || isScalaVararg;
        if (this.invocation.getRawArguments().length == this.matchers.size() && isVararg) {
            return this.argsMatch(this.invocation.getRawArguments(), this.matchers, action);
        }
        if (this.invocation.getArguments().length == this.matchers.size()) {
            return this.argsMatch(this.invocation.getArguments(), this.matchers, action);
        }
        return false;
    }

    private boolean argsMatch(Object[] arguments, List<? extends ArgumentMatcher<?>> matchers, ArgumentMatcherAction action) {
        for (int i = 0; i < arguments.length; ++i) {
            Object argument;
            ArgumentMatcher<?> matcher = matchers.get(i);
            if (action.apply(matcher, argument = arguments[i])) continue;
            return false;
        }
        return true;
    }

    private Optional<Class<?>> lastMatcherType() {
        return this.matchers.isEmpty() ? Optional.empty() : Optional.of(this.matchers.get(this.matchers.size() - 1).type());
    }

    private Class<?> lastParameterType() {
        Class<?>[] parameterTypes = this.invocation.getMethod().getParameterTypes();
        return parameterTypes[parameterTypes.length - 1];
    }

    Optional<Class<?>> optionalClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

